/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.store;

import com.carrotsearch.randomizedtesting.SeedUtils;
import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Random;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.MockDirectoryWrapper;
import org.apache.lucene.store.StoreRateLimiting;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestRuleMarkFailure;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardPath;
import org.elasticsearch.index.store.FsDirectoryService;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.test.ESIntegTestCase;
import org.elasticsearch.test.ESTestCase;
import org.junit.Assert;

public class MockFSDirectoryService
extends FsDirectoryService {
    public static final Setting<Double> RANDOM_IO_EXCEPTION_RATE_ON_OPEN_SETTING = Setting.doubleSetting((String)"index.store.mock.random.io_exception_rate_on_open", (double)0.0, (double)0.0, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.NodeScope});
    public static final Setting<Double> RANDOM_IO_EXCEPTION_RATE_SETTING = Setting.doubleSetting((String)"index.store.mock.random.io_exception_rate", (double)0.0, (double)0.0, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.NodeScope});
    public static final Setting<Boolean> RANDOM_PREVENT_DOUBLE_WRITE_SETTING = Setting.boolSetting((String)"index.store.mock.random.prevent_double_write", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.NodeScope});
    public static final Setting<Boolean> RANDOM_NO_DELETE_OPEN_FILE_SETTING = Setting.boolSetting((String)"index.store.mock.random.no_delete_open_file", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.NodeScope});
    public static final Setting<Boolean> CRASH_INDEX_SETTING = Setting.boolSetting((String)"index.store.mock.random.crash_index", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.NodeScope});
    private final FsDirectoryService delegateService;
    private final Random random;
    private final double randomIOExceptionRate;
    private final double randomIOExceptionRateOnOpen;
    private final MockDirectoryWrapper.Throttling throttle;
    private final boolean preventDoubleWrite;
    private final boolean noDeleteOpenFile;
    private final boolean crashIndex;

    @Inject
    public MockFSDirectoryService(IndexSettings idxSettings, IndexStore indexStore, ShardPath path) {
        super(idxSettings, indexStore, path);
        Settings indexSettings = idxSettings.getSettings();
        long seed = (Long)idxSettings.getValue(ESIntegTestCase.INDEX_TEST_SEED_SETTING);
        this.random = new Random(seed);
        this.randomIOExceptionRate = (Double)RANDOM_IO_EXCEPTION_RATE_SETTING.get(indexSettings);
        this.randomIOExceptionRateOnOpen = (Double)RANDOM_IO_EXCEPTION_RATE_ON_OPEN_SETTING.get(indexSettings);
        this.preventDoubleWrite = (Boolean)RANDOM_PREVENT_DOUBLE_WRITE_SETTING.get(indexSettings);
        this.noDeleteOpenFile = RANDOM_NO_DELETE_OPEN_FILE_SETTING.exists(indexSettings) ? ((Boolean)RANDOM_NO_DELETE_OPEN_FILE_SETTING.get(indexSettings)).booleanValue() : this.random.nextBoolean();
        this.random.nextInt(this.shardId.getId() + 1);
        this.throttle = MockDirectoryWrapper.Throttling.NEVER;
        this.crashIndex = (Boolean)CRASH_INDEX_SETTING.get(indexSettings);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Using MockDirWrapper with seed [{}] throttle: [{}] crashIndex: [{}]", (Object)SeedUtils.formatSeed((long)seed), (Object)this.throttle, (Object)this.crashIndex);
        }
        this.delegateService = this.randomDirectorService(indexStore, path);
    }

    public Directory newDirectory() throws IOException {
        return this.wrap(this.delegateService.newDirectory());
    }

    protected synchronized Directory newFSDirectory(Path location, LockFactory lockFactory) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkIndex(Logger logger, Store store, ShardId shardId) {
        if (store.tryIncRef()) {
            logger.info("start check index");
            try {
                Directory dir = store.directory();
                if (!Lucene.indexExists((Directory)dir)) {
                    return;
                }
                try (CheckIndex checkIndex = new CheckIndex(dir);){
                    BytesStreamOutput os = new BytesStreamOutput();
                    PrintStream out = new PrintStream((OutputStream)os, false, StandardCharsets.UTF_8.name());
                    checkIndex.setInfoStream(out);
                    out.flush();
                    CheckIndex.Status status = checkIndex.checkIndex();
                    if (!status.clean) {
                        ESTestCase.checkIndexFailed = true;
                        logger.warn("check index [failure] index files={}\n{}", (Object)Arrays.toString(dir.listAll()), (Object)os.bytes().utf8ToString());
                        throw new IOException("index check failure");
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("check index [success]\n{}", (Object)os.bytes().utf8ToString());
                    }
                }
                catch (LockObtainFailedException e) {
                    ESTestCase.checkIndexFailed = true;
                    throw new IllegalStateException("IndexWriter is still open on shard " + shardId, e);
                }
            }
            catch (Exception e) {
                logger.warn("failed to check index", (Throwable)e);
            }
            finally {
                logger.info("end check index");
                store.decRef();
            }
        }
    }

    public void onPause(long nanos) {
        this.delegateService.onPause(nanos);
    }

    public StoreRateLimiting rateLimiting() {
        return this.delegateService.rateLimiting();
    }

    public long throttleTimeInNanos() {
        return this.delegateService.throttleTimeInNanos();
    }

    private Directory wrap(Directory dir) {
        ElasticsearchMockDirectoryWrapper w = new ElasticsearchMockDirectoryWrapper(this.random, dir, this.crashIndex);
        w.setRandomIOExceptionRate(this.randomIOExceptionRate);
        w.setRandomIOExceptionRateOnOpen(this.randomIOExceptionRateOnOpen);
        w.setThrottling(this.throttle);
        w.setCheckIndexOnClose(false);
        w.setAssertNoDeleteOpenFile(false);
        w.setUseSlowOpenClosers(false);
        LuceneTestCase.closeAfterSuite((Closeable)new CloseableDirectory((BaseDirectoryWrapper)w));
        return w;
    }

    private FsDirectoryService randomDirectorService(IndexStore indexStore, ShardPath path) {
        IndexSettings indexSettings = indexStore.getIndexSettings();
        IndexMetaData build = IndexMetaData.builder((IndexMetaData)indexSettings.getIndexMetaData()).settings(Settings.builder().put(indexSettings.getSettings()).put(IndexModule.INDEX_STORE_TYPE_SETTING.getKey(), ((IndexModule.Type)RandomPicks.randomFrom((Random)this.random, (Object[])IndexModule.Type.values())).getSettingsKey())).build();
        IndexSettings newIndexSettings = new IndexSettings(build, indexSettings.getNodeSettings());
        return new FsDirectoryService(newIndexSettings, indexStore, path);
    }

    final class CloseableDirectory
    implements Closeable {
        private final BaseDirectoryWrapper dir;
        private final TestRuleMarkFailure failureMarker;

        CloseableDirectory(BaseDirectoryWrapper dir) {
            this.dir = dir;
            this.failureMarker = ESTestCase.getSuiteFailureMarker();
        }

        @Override
        public void close() {
            if (this.failureMarker.wasSuccessful() && this.dir.isOpen()) {
                Assert.fail((String)("Directory not closed: " + this.dir));
            }
        }
    }

    public static final class ElasticsearchMockDirectoryWrapper
    extends MockDirectoryWrapper {
        private final boolean crash;

        public ElasticsearchMockDirectoryWrapper(Random random, Directory delegate, boolean crash) {
            super(random, delegate);
            this.crash = crash;
        }

        public synchronized void crash() throws IOException {
            if (this.crash) {
                super.crash();
            }
        }
    }
}

