/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.index.similarity.ScriptedSimilarity;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.FilterScript;
import org.elasticsearch.script.ScoreAccessor;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptEngine;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.script.SimilarityScript;
import org.elasticsearch.script.SimilarityWeightScript;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.SearchLookup;

public class MockScriptEngine
implements ScriptEngine {
    public static final String NAME = "mockscript";
    private final String type;
    private final Map<String, Function<Map<String, Object>, Object>> scripts;

    public MockScriptEngine(String type, Map<String, Function<Map<String, Object>, Object>> scripts) {
        this.type = type;
        this.scripts = Collections.unmodifiableMap(scripts);
    }

    public MockScriptEngine() {
        this(NAME, Collections.emptyMap());
    }

    public String getType() {
        return this.type;
    }

    public <T> T compile(String name, String source, ScriptContext<T> context, Map<String, String> params) {
        Function<Map<String, Object>, Object> script = this.scripts.get(source);
        if (script == null) {
            throw new IllegalArgumentException("No pre defined script matching [" + source + "] for script with name [" + name + "], did you declare the mocked script?");
        }
        MockCompiledScript mockCompiled = new MockCompiledScript(name, params, source, script);
        if (context.instanceClazz.equals(SearchScript.class)) {
            SearchScript.Factory factory = mockCompiled::createSearchScript;
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(ExecutableScript.class)) {
            ExecutableScript.Factory factory = mockCompiled::createExecutableScript;
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(TemplateScript.class)) {
            TemplateScript.Factory factory = vars -> {
                final ExecutableScript execScript = mockCompiled.createExecutableScript(vars);
                return new TemplateScript(vars){

                    public String execute() {
                        return (String)execScript.run();
                    }
                };
            };
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(FilterScript.class)) {
            FilterScript.Factory factory = mockCompiled::createFilterScript;
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(SimilarityScript.class)) {
            SimilarityScript.Factory factory = mockCompiled::createSimilarityScript;
            return context.factoryClazz.cast(factory);
        }
        if (context.instanceClazz.equals(SimilarityWeightScript.class)) {
            SimilarityWeightScript.Factory factory = mockCompiled::createSimilarityWeightScript;
            return context.factoryClazz.cast(factory);
        }
        throw new IllegalArgumentException("mock script engine does not know how to handle context [" + context.name + "]");
    }

    public static Script mockInlineScript(String script) {
        return new Script(ScriptType.INLINE, "mock", script, Collections.emptyMap());
    }

    public class MockSimilarityWeightScript
    extends SimilarityWeightScript {
        private final Function<Map<String, Object>, Object> script;

        MockSimilarityWeightScript(Function<Map<String, Object>, Object> script) {
            this.script = script;
        }

        public double execute(ScriptedSimilarity.Query query, ScriptedSimilarity.Field field, ScriptedSimilarity.Term term) throws IOException {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("query", query);
            map.put("field", field);
            map.put("term", term);
            return ((Number)this.script.apply(map)).doubleValue();
        }
    }

    public class MockSimilarityScript
    extends SimilarityScript {
        private final Function<Map<String, Object>, Object> script;

        MockSimilarityScript(Function<Map<String, Object>, Object> script) {
            this.script = script;
        }

        public double execute(double weight, ScriptedSimilarity.Query query, ScriptedSimilarity.Field field, ScriptedSimilarity.Term term, ScriptedSimilarity.Doc doc) throws IOException {
            HashMap<String, Double> map = new HashMap<String, Double>();
            map.put("weight", weight);
            map.put("query", (Double)query);
            map.put("field", (Double)field);
            map.put("term", (Double)term);
            map.put("doc", (Double)doc);
            return ((Number)this.script.apply(map)).doubleValue();
        }
    }

    public static class MockFilterScript
    implements FilterScript.LeafFactory {
        private final Function<Map<String, Object>, Object> script;
        private final Map<String, Object> vars;
        private final SearchLookup lookup;

        public MockFilterScript(SearchLookup lookup, Map<String, Object> vars, Function<Map<String, Object>, Object> script) {
            this.lookup = lookup;
            this.vars = vars;
            this.script = script;
        }

        public FilterScript newInstance(LeafReaderContext context) throws IOException {
            final LeafSearchLookup leafLookup = this.lookup.getLeafSearchLookup(context);
            final HashMap<String, Object> ctx = new HashMap<String, Object>(leafLookup.asMap());
            if (this.vars != null) {
                ctx.putAll(this.vars);
            }
            return new FilterScript(ctx, this.lookup, context){

                public boolean execute() {
                    return (Boolean)script.apply(ctx);
                }

                public void setDocument(int doc) {
                    leafLookup.setDocument(doc);
                }
            };
        }
    }

    public class MockSearchScript
    implements SearchScript.LeafFactory {
        private final Function<Map<String, Object>, Object> script;
        private final Map<String, Object> vars;
        private final SearchLookup lookup;

        public MockSearchScript(SearchLookup lookup, Map<String, Object> vars, Function<Map<String, Object>, Object> script) {
            this.lookup = lookup;
            this.vars = vars;
            this.script = script;
        }

        public SearchScript newInstance(LeafReaderContext context) throws IOException {
            final LeafSearchLookup leafLookup = this.lookup.getLeafSearchLookup(context);
            final HashMap<String, Object> ctx = new HashMap<String, Object>(leafLookup.asMap());
            if (this.vars != null) {
                ctx.putAll(this.vars);
            }
            return new SearchScript(this.vars, this.lookup, context){

                public Object run() {
                    return MockSearchScript.this.script.apply(ctx);
                }

                public long runAsLong() {
                    return ((Number)this.run()).longValue();
                }

                public double runAsDouble() {
                    return ((Number)this.run()).doubleValue();
                }

                public void setNextVar(String name, Object value) {
                    ctx.put(name, value);
                }

                public void setScorer(Scorer scorer) {
                    ctx.put("_score", new ScoreAccessor(scorer));
                }

                public void setDocument(int doc) {
                    leafLookup.setDocument(doc);
                }
            };
        }

        public boolean needs_score() {
            return true;
        }
    }

    public class MockExecutableScript
    implements ExecutableScript {
        private final Function<Map<String, Object>, Object> script;
        private final Map<String, Object> vars;

        public MockExecutableScript(Map<String, Object> vars, Function<Map<String, Object>, Object> script) {
            this.vars = vars;
            this.script = script;
        }

        public void setNextVar(String name, Object value) {
            this.vars.put(name, value);
        }

        public Object run() {
            return this.script.apply(this.vars);
        }
    }

    public class MockCompiledScript {
        private final String name;
        private final String source;
        private final Map<String, String> options;
        private final Function<Map<String, Object>, Object> script;

        public MockCompiledScript(String name, Map<String, String> options, String source, Function<Map<String, Object>, Object> script) {
            this.name = name;
            this.source = source;
            this.options = options;
            this.script = script;
        }

        public String getName() {
            return this.name;
        }

        public ExecutableScript createExecutableScript(Map<String, Object> params) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            if (this.options != null) {
                context.putAll(this.options);
                context.put("options", this.options);
            }
            if (params != null) {
                context.putAll(params);
                context.put("params", params);
            }
            return new MockExecutableScript(context, this.script != null ? this.script : ctx -> this.source);
        }

        public SearchScript.LeafFactory createSearchScript(Map<String, Object> params, SearchLookup lookup) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            if (this.options != null) {
                context.putAll(this.options);
                context.put("options", this.options);
            }
            if (params != null) {
                context.putAll(params);
                context.put("params", params);
            }
            return new MockSearchScript(lookup, context, this.script != null ? this.script : ctx -> this.source);
        }

        public FilterScript.LeafFactory createFilterScript(Map<String, Object> params, SearchLookup lookup) {
            return new MockFilterScript(lookup, params, this.script);
        }

        public SimilarityScript createSimilarityScript() {
            return new MockSimilarityScript(this.script != null ? this.script : ctx -> 42.0);
        }

        public SimilarityWeightScript createSimilarityWeightScript() {
            return new MockSimilarityWeightScript(this.script != null ? this.script : ctx -> 42.0);
        }
    }
}

