/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.BytesStreamOutput;

public class StreamsUtils {
    public static String copyToStringFromClasspath(ClassLoader classLoader, String path) throws IOException {
        InputStream is = classLoader.getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException("Resource [" + path + "] not found in classpath with class loader [" + classLoader + "]");
        }
        return Streams.copyToString((Reader)new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    public static String copyToStringFromClasspath(String path) throws IOException {
        InputStream is = org.elasticsearch.core.internal.io.Streams.class.getResourceAsStream(path);
        if (is == null) {
            throw new FileNotFoundException("Resource [" + path + "] not found in classpath");
        }
        return Streams.copyToString((Reader)new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    public static byte[] copyToBytesFromClasspath(String path) throws IOException {
        Throwable throwable = null;
        try (InputStream is = org.elasticsearch.core.internal.io.Streams.class.getResourceAsStream(path);){
            byte[] byArray;
            if (is == null) {
                throw new FileNotFoundException("Resource [" + path + "] not found in classpath");
            }
            BytesStreamOutput out = new BytesStreamOutput();
            Throwable throwable2 = null;
            try {
                org.elasticsearch.core.internal.io.Streams.copy((InputStream)is, (OutputStream)out);
                byArray = BytesReference.toBytes((BytesReference)out.bytes());
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        StreamsUtils.$closeResource(throwable2, (AutoCloseable)out);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            StreamsUtils.$closeResource(throwable2, (AutoCloseable)out);
            return byArray;
        }
    }
}

