/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.discovery;

import java.io.Closeable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.discovery.zen.UnicastHostsProvider;

public final class MockUncasedHostProvider
implements UnicastHostsProvider,
Closeable {
    static final Map<ClusterName, Set<MockUncasedHostProvider>> activeNodesPerCluster = new HashMap<ClusterName, Set<MockUncasedHostProvider>>();
    private final Supplier<DiscoveryNode> localNodeSupplier;
    private final ClusterName clusterName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MockUncasedHostProvider(Supplier<DiscoveryNode> localNodeSupplier, ClusterName clusterName) {
        this.localNodeSupplier = localNodeSupplier;
        this.clusterName = clusterName;
        Map<ClusterName, Set<MockUncasedHostProvider>> map = activeNodesPerCluster;
        synchronized (map) {
            this.getActiveNodesForCurrentCluster().add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DiscoveryNode> buildDynamicNodes() {
        DiscoveryNode localNode = this.getNode();
        assert (localNode != null);
        Map<ClusterName, Set<MockUncasedHostProvider>> map = activeNodesPerCluster;
        synchronized (map) {
            Set<MockUncasedHostProvider> activeNodes = this.getActiveNodesForCurrentCluster();
            return activeNodes.stream().map(MockUncasedHostProvider::getNode).filter(Objects::nonNull).filter(n -> !localNode.equals(n)).collect(Collectors.toList());
        }
    }

    @Nullable
    private DiscoveryNode getNode() {
        return this.localNodeSupplier.get();
    }

    private Set<MockUncasedHostProvider> getActiveNodesForCurrentCluster() {
        assert (Thread.holdsLock(activeNodesPerCluster));
        return activeNodesPerCluster.computeIfAbsent(this.clusterName, clusterName -> ConcurrentCollections.newConcurrentSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Map<ClusterName, Set<MockUncasedHostProvider>> map = activeNodesPerCluster;
        synchronized (map) {
            boolean found = this.getActiveNodesForCurrentCluster().remove(this);
            assert (found);
        }
    }
}

