/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.ssl.SSLContexts;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.common.CheckedRunnable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.test.ESTestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;

public abstract class ESRestTestCase
extends ESTestCase {
    public static final String TRUSTSTORE_PATH = "truststore.path";
    public static final String TRUSTSTORE_PASSWORD = "truststore.password";
    public static final String CLIENT_RETRY_TIMEOUT = "client.retry.timeout";
    public static final String CLIENT_SOCKET_TIMEOUT = "client.socket.timeout";
    private static List<HttpHost> clusterHosts;
    private static RestClient client;
    private static RestClient adminClient;

    public Map<String, Object> entityAsMap(Response response) throws IOException {
        XContentType xContentType = XContentType.fromMediaTypeOrFormat((String)response.getEntity().getContentType().getValue());
        try (XContentParser parser = this.createParser(xContentType.xContent(), response.getEntity().getContent());){
            Map map = parser.map();
            return map;
        }
    }

    @Before
    public void initClient() throws IOException {
        if (client == null) {
            assert (adminClient == null);
            assert (clusterHosts == null);
            String cluster = System.getProperty("tests.rest.cluster");
            if (cluster == null) {
                throw new RuntimeException("Must specify [tests.rest.cluster] system property with a comma delimited list of [host:port] to which to send REST requests");
            }
            String[] stringUrls = cluster.split(",");
            ArrayList<HttpHost> hosts = new ArrayList<HttpHost>(stringUrls.length);
            for (String stringUrl : stringUrls) {
                int portSeparator = stringUrl.lastIndexOf(58);
                if (portSeparator < 0) {
                    throw new IllegalArgumentException("Illegal cluster url [" + stringUrl + "]");
                }
                String host = stringUrl.substring(0, portSeparator);
                int port = Integer.valueOf(stringUrl.substring(portSeparator + 1));
                hosts.add(new HttpHost(host, port, this.getProtocol()));
            }
            clusterHosts = Collections.unmodifiableList(hosts);
            this.logger.info("initializing REST clients against {}", clusterHosts);
            client = this.buildClient(this.restClientSettings(), clusterHosts.toArray(new HttpHost[clusterHosts.size()]));
            adminClient = this.buildClient(this.restAdminSettings(), clusterHosts.toArray(new HttpHost[clusterHosts.size()]));
        }
        assert (client != null);
        assert (adminClient != null);
        assert (clusterHosts != null);
    }

    @After
    public final void cleanUpCluster() throws Exception {
        if (!this.preserveClusterUponCompletion()) {
            this.wipeCluster();
            this.waitForClusterStateUpdatesToFinish();
            this.logIfThereAreRunningTasks();
        }
    }

    @AfterClass
    public static void closeClients() throws IOException {
        try {
            IOUtils.close((Closeable[])new Closeable[]{client, adminClient});
        }
        finally {
            clusterHosts = null;
            client = null;
            adminClient = null;
        }
    }

    protected static RestClient client() {
        return client;
    }

    protected static RestClient adminClient() {
        return adminClient;
    }

    protected boolean preserveClusterUponCompletion() {
        return false;
    }

    protected boolean preserveIndicesUponCompletion() {
        return false;
    }

    protected boolean preserveTemplatesUponCompletion() {
        return false;
    }

    protected boolean preserveReposUponCompletion() {
        return false;
    }

    protected boolean preserveSnapshotsUponCompletion() {
        return false;
    }

    private void wipeCluster() throws IOException {
        block4: {
            if (!this.preserveIndicesUponCompletion()) {
                try {
                    ESRestTestCase.adminClient().performRequest("DELETE", "*", new Header[0]);
                }
                catch (ResponseException e) {
                    if (e.getResponse().getStatusLine().getStatusCode() == 404) break block4;
                    throw e;
                }
            }
        }
        if (!this.preserveTemplatesUponCompletion()) {
            ESRestTestCase.adminClient().performRequest("DELETE", "_template/*", new Header[0]);
        }
        this.wipeSnapshots();
        this.wipeClusterSettings();
    }

    private void wipeSnapshots() throws IOException {
        for (Map.Entry<String, Object> repo : this.entityAsMap(adminClient.performRequest("GET", "_snapshot/_all", new Header[0])).entrySet()) {
            String repoName = repo.getKey();
            Map repoSpec = (Map)repo.getValue();
            String repoType = (String)repoSpec.get("type");
            if (!this.preserveSnapshotsUponCompletion() && repoType.equals("fs")) {
                String url = "_snapshot/" + repoName + "/_all";
                Map<String, String> params = Collections.singletonMap("ignore_unavailable", "true");
                List snapshots = (List)this.entityAsMap(adminClient.performRequest("GET", url, params, new Header[0])).get("snapshots");
                for (Object snapshot : snapshots) {
                    Map snapshotInfo = (Map)snapshot;
                    String name = (String)snapshotInfo.get("snapshot");
                    this.logger.debug("wiping snapshot [{}/{}]", (Object)repoName, (Object)name);
                    ESRestTestCase.adminClient().performRequest("DELETE", "_snapshot/" + repoName + "/" + name, new Header[0]);
                }
            }
            if (this.preserveReposUponCompletion()) continue;
            this.logger.debug("wiping snapshot repository [{}]", (Object)repoName);
            ESRestTestCase.adminClient().performRequest("DELETE", "_snapshot/" + repoName, new Header[0]);
        }
    }

    private void wipeClusterSettings() throws IOException {
        Map<String, Object> getResponse = this.entityAsMap(ESRestTestCase.adminClient().performRequest("GET", "/_cluster/settings", new Header[0]));
        boolean mustClear = false;
        XContentBuilder clearCommand = JsonXContent.contentBuilder();
        clearCommand.startObject();
        for (Map.Entry<String, Object> entry : getResponse.entrySet()) {
            String type = entry.getKey().toString();
            Map settings = (Map)entry.getValue();
            if (settings.isEmpty()) continue;
            mustClear = true;
            clearCommand.startObject(type);
            for (Object key : settings.keySet()) {
                clearCommand.field(key + ".*").nullValue();
            }
            clearCommand.endObject();
        }
        clearCommand.endObject();
        if (mustClear) {
            ESRestTestCase.adminClient().performRequest("PUT", "/_cluster/settings", Collections.emptyMap(), (HttpEntity)new StringEntity(Strings.toString((XContentBuilder)clearCommand), ContentType.APPLICATION_JSON), new Header[0]);
        }
    }

    private void logIfThereAreRunningTasks() throws InterruptedException, IOException {
        Set<String> runningTasks = this.runningTasks(ESRestTestCase.adminClient().performRequest("GET", "_tasks", new Header[0]));
        runningTasks.remove("cluster:monitor/tasks/lists");
        runningTasks.remove("cluster:monitor/tasks/lists[n]");
        if (runningTasks.isEmpty()) {
            return;
        }
        ArrayList<String> stillRunning = new ArrayList<String>(runningTasks);
        Collections.sort(stillRunning);
        this.logger.info("There are still tasks running after this test that might break subsequent tests {}.", stillRunning);
    }

    private void waitForClusterStateUpdatesToFinish() throws Exception {
        ESRestTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            try {
                Response response = ESRestTestCase.adminClient().performRequest("GET", "_cluster/pending_tasks", new Header[0]);
                List tasks = (List)this.entityAsMap(response).get("tasks");
                if (!tasks.isEmpty()) {
                    StringBuilder message = new StringBuilder("there are still running tasks:");
                    for (Object task : tasks) {
                        message.append('\n').append(task.toString());
                    }
                    ESRestTestCase.fail((String)message.toString());
                }
            }
            catch (IOException e) {
                ESRestTestCase.fail((String)("cannot get cluster's pending tasks: " + e.getMessage()));
            }
        }), 30L, TimeUnit.SECONDS);
    }

    protected Settings restClientSettings() {
        return Settings.EMPTY;
    }

    protected Settings restAdminSettings() {
        return this.restClientSettings();
    }

    protected final List<HttpHost> getClusterHosts() {
        return clusterHosts;
    }

    protected String getProtocol() {
        return "http";
    }

    protected RestClient buildClient(Settings settings, HttpHost[] hosts) throws IOException {
        String socketTimeoutString;
        Object path;
        RestClientBuilder builder = RestClient.builder((HttpHost[])hosts);
        String keystorePath = settings.get(TRUSTSTORE_PATH);
        if (keystorePath != null) {
            String keystorePass = settings.get(TRUSTSTORE_PASSWORD);
            if (keystorePass == null) {
                throw new IllegalStateException("truststore.path is provided but not truststore.password");
            }
            path = PathUtils.get((String)keystorePath, (String[])new String[0]);
            if (!Files.exists((Path)path, new LinkOption[0])) {
                throw new IllegalStateException("truststore.path is set but points to a non-existing file");
            }
            try {
                KeyStore keyStore = KeyStore.getInstance("jks");
                InputStream is = Files.newInputStream((Path)path, new OpenOption[0]);
                Object object = null;
                try {
                    keyStore.load(is, keystorePass.toCharArray());
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (is != null) {
                        ESRestTestCase.$closeResource((Throwable)object, is);
                    }
                }
                SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(keyStore, null).build();
                SSLIOSessionStrategy sessionStrategy = new SSLIOSessionStrategy(sslcontext);
                builder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setSSLStrategy((SchemeIOSessionStrategy)sessionStrategy));
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new RuntimeException("Error setting up ssl", e);
            }
        }
        path = null;
        try (ThreadContext threadContext = new ThreadContext(settings);){
            Header[] defaultHeaders = new Header[threadContext.getHeaders().size()];
            int i = 0;
            for (Map.Entry entry : threadContext.getHeaders().entrySet()) {
                defaultHeaders[i++] = new BasicHeader((String)entry.getKey(), (String)entry.getValue());
            }
            builder.setDefaultHeaders(defaultHeaders);
        }
        catch (Throwable defaultHeaders) {
            path = defaultHeaders;
            throw defaultHeaders;
        }
        String requestTimeoutString = settings.get(CLIENT_RETRY_TIMEOUT);
        if (requestTimeoutString != null) {
            TimeValue maxRetryTimeout = TimeValue.parseTimeValue((String)requestTimeoutString, (String)CLIENT_RETRY_TIMEOUT);
            builder.setMaxRetryTimeoutMillis(Math.toIntExact(maxRetryTimeout.getMillis()));
        }
        if ((socketTimeoutString = settings.get(CLIENT_SOCKET_TIMEOUT)) != null) {
            TimeValue socketTimeout = TimeValue.parseTimeValue((String)socketTimeoutString, (String)CLIENT_SOCKET_TIMEOUT);
            builder.setRequestConfigCallback(conf -> conf.setSocketTimeout(Math.toIntExact(socketTimeout.getMillis())));
        }
        return builder.build();
    }

    private Set<String> runningTasks(Response response) throws IOException {
        HashSet<String> runningTasks = new HashSet<String>();
        Map nodes = (Map)this.entityAsMap(response).get("nodes");
        for (Map.Entry node : nodes.entrySet()) {
            Map nodeInfo = (Map)node.getValue();
            Map nodeTasks = (Map)nodeInfo.get("tasks");
            for (Map.Entry taskAndName : nodeTasks.entrySet()) {
                Map task = (Map)taskAndName.getValue();
                runningTasks.add(task.get("action").toString());
            }
        }
        return runningTasks;
    }

    protected static void assertOK(Response response) {
        ESRestTestCase.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)200), (Matcher)Matchers.equalTo((Object)201)));
    }

    protected static void ensureGreen(String index) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("wait_for_status", "green");
        params.put("wait_for_no_relocating_shards", "true");
        params.put("timeout", "70s");
        params.put("level", "shards");
        ESRestTestCase.assertOK(ESRestTestCase.client().performRequest("GET", "_cluster/health/" + index, params, new Header[0]));
    }

    protected static void ensureNoInitializingShards() throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("wait_for_no_initializing_shards", "true");
        params.put("timeout", "70s");
        params.put("level", "shards");
        ESRestTestCase.assertOK(ESRestTestCase.client().performRequest("GET", "_cluster/health/", params, new Header[0]));
    }

    protected static void createIndex(String name, Settings settings) throws IOException {
        ESRestTestCase.createIndex(name, settings, "");
    }

    protected static void createIndex(String name, Settings settings, String mapping) throws IOException {
        ESRestTestCase.assertOK(ESRestTestCase.client().performRequest("PUT", name, Collections.emptyMap(), (HttpEntity)new StringEntity("{ \"settings\": " + Strings.toString((ToXContent)settings) + ", \"mappings\" : {" + mapping + "} }", ContentType.APPLICATION_JSON), new Header[0]));
    }

    protected static void updateIndexSettings(String index, Settings.Builder settings) throws IOException {
        ESRestTestCase.updateIndexSettings(index, settings.build());
    }

    private static void updateIndexSettings(String index, Settings settings) throws IOException {
        ESRestTestCase.assertOK(ESRestTestCase.client().performRequest("PUT", index + "/_settings", Collections.emptyMap(), (HttpEntity)new StringEntity(Strings.toString((ToXContent)settings), ContentType.APPLICATION_JSON), new Header[0]));
    }

    protected static Map<String, Object> getIndexSettings(String index) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("flat_settings", "true");
        Response response = ESRestTestCase.client().performRequest("GET", index + "/_settings", params, new Header[0]);
        ESRestTestCase.assertOK(response);
        try (InputStream is = response.getEntity().getContent();){
            Map map = XContentHelper.convertToMap((XContent)XContentType.JSON.xContent(), (InputStream)is, (boolean)true);
            return map;
        }
    }

    protected static boolean indexExists(String index) throws IOException {
        Response response = ESRestTestCase.client().performRequest("HEAD", index, new Header[0]);
        return RestStatus.OK.getStatus() == response.getStatusLine().getStatusCode();
    }

    protected static void closeIndex(String index) throws IOException {
        Response response = ESRestTestCase.client().performRequest("POST", index + "/_close", new Header[0]);
        ESRestTestCase.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.equalTo((Object)RestStatus.OK.getStatus()));
    }

    protected static void openIndex(String index) throws IOException {
        Response response = ESRestTestCase.client().performRequest("POST", index + "/_open", new Header[0]);
        ESRestTestCase.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.equalTo((Object)RestStatus.OK.getStatus()));
    }

    protected static boolean aliasExists(String alias) throws IOException {
        Response response = ESRestTestCase.client().performRequest("HEAD", "/_alias/" + alias, new Header[0]);
        return RestStatus.OK.getStatus() == response.getStatusLine().getStatusCode();
    }

    protected static boolean aliasExists(String index, String alias) throws IOException {
        Response response = ESRestTestCase.client().performRequest("HEAD", "/" + index + "/_alias/" + alias, new Header[0]);
        return RestStatus.OK.getStatus() == response.getStatusLine().getStatusCode();
    }

    protected static Map<String, Object> getAlias(String index, String alias) throws IOException {
        String endpoint = "/_alias";
        if (!Strings.isEmpty((CharSequence)index)) {
            endpoint = index + endpoint;
        }
        if (!Strings.isEmpty((CharSequence)alias)) {
            endpoint = endpoint + "/" + alias;
        }
        Map<String, Object> getAliasResponse = ESRestTestCase.getAsMap(endpoint);
        return (Map)XContentMapValues.extractValue((String)(index + ".aliases." + alias), getAliasResponse);
    }

    protected static Map<String, Object> getAsMap(String endpoint) throws IOException {
        Response response = ESRestTestCase.client().performRequest("GET", endpoint, new Header[0]);
        XContentType entityContentType = XContentType.fromMediaTypeOrFormat((String)response.getEntity().getContentType().getValue());
        Map responseEntity = XContentHelper.convertToMap((XContent)entityContentType.xContent(), (InputStream)response.getEntity().getContent(), (boolean)false);
        ESRestTestCase.assertNotNull((Object)responseEntity);
        return responseEntity;
    }
}

