/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.CancellableThreads;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.mocksocket.MockServerSocket;
import org.elasticsearch.mocksocket.MockSocket;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.TransportRequestOptions;

public class MockTcpTransport
extends TcpTransport {
    public static final ConnectionProfile LIGHT_PROFILE;
    private final Set<MockChannel> openChannels = new HashSet<MockChannel>();
    private final ExecutorService executor;
    private final Version mockVersion;

    public MockTcpTransport(Settings settings, ThreadPool threadPool, BigArrays bigArrays, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService) {
        this(settings, threadPool, bigArrays, circuitBreakerService, namedWriteableRegistry, networkService, Version.CURRENT);
    }

    public MockTcpTransport(Settings settings, ThreadPool threadPool, BigArrays bigArrays, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService, Version mockVersion) {
        super("mock-tcp-transport", settings, threadPool, bigArrays, circuitBreakerService, namedWriteableRegistry, networkService);
        this.executor = Executors.newCachedThreadPool(EsExecutors.daemonThreadFactory((Settings)settings, (String)"__mock_network_thread"));
        this.mockVersion = mockVersion;
    }

    protected MockChannel bind(String name, InetSocketAddress address) throws IOException {
        MockServerSocket socket = new MockServerSocket();
        socket.setReuseAddress(((Boolean)TCP_REUSE_ADDRESS.get(this.settings)).booleanValue());
        ByteSizeValue tcpReceiveBufferSize = (ByteSizeValue)TCP_RECEIVE_BUFFER_SIZE.get(this.settings);
        if (tcpReceiveBufferSize.getBytes() > 0L) {
            socket.setReceiveBufferSize(tcpReceiveBufferSize.bytesAsInt());
        }
        socket.bind((SocketAddress)address);
        final MockChannel serverMockChannel = new MockChannel((ServerSocket)socket, name);
        final CountDownLatch started = new CountDownLatch(1);
        this.executor.execute((Runnable)new AbstractRunnable(){

            public void onFailure(Exception e) {
                MockTcpTransport.this.onException(serverMockChannel, e);
            }

            protected void doRun() throws Exception {
                started.countDown();
                serverMockChannel.accept(MockTcpTransport.this.executor);
            }
        });
        try {
            started.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return serverMockChannel;
    }

    private void readMessage(MockChannel mockChannel, StreamInput input) throws IOException {
        Socket socket = mockChannel.activeChannel;
        byte[] minimalHeader = new byte[2];
        int firstByte = input.read();
        if (firstByte == -1) {
            throw new IOException("Connection reset by peer");
        }
        minimalHeader[0] = (byte)firstByte;
        minimalHeader[1] = (byte)input.read();
        int msgSize = input.readInt();
        if (msgSize == -1) {
            socket.getOutputStream().flush();
        } else {
            BytesStreamOutput output = new BytesStreamOutput();
            byte[] buffer = new byte[msgSize];
            input.readFully(buffer);
            output.write(minimalHeader);
            output.writeInt(msgSize);
            output.write(buffer);
            BytesReference bytes = output.bytes();
            if (TcpTransport.validateMessageHeader((BytesReference)bytes)) {
                InetSocketAddress remoteAddress = (InetSocketAddress)socket.getRemoteSocketAddress();
                this.messageReceived(bytes.slice(6, msgSize), mockChannel, mockChannel.profile, remoteAddress, msgSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MockChannel initiateChannel(DiscoveryNode node, TimeValue connectTimeout, ActionListener<Void> connectListener) throws IOException {
        MockChannel mockChannel;
        block5: {
            InetSocketAddress address = node.getAddress().address();
            MockSocket socket = new MockSocket();
            boolean success = false;
            try {
                this.configureSocket((Socket)socket);
                try {
                    socket.connect((SocketAddress)address, Math.toIntExact(connectTimeout.millis()));
                }
                catch (SocketTimeoutException ex) {
                    throw new ConnectTransportException(node, "connect_timeout[" + connectTimeout + "]", (Throwable)ex);
                }
                MockChannel channel = new MockChannel((Socket)socket, address, "none", c -> {});
                channel.loopRead(this.executor);
                success = true;
                connectListener.onResponse(null);
                mockChannel = channel;
                if (success) break block5;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.close((Closeable[])new Closeable[]{socket});
                }
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{socket});
        }
        return mockChannel;
    }

    protected ConnectionProfile resolveConnectionProfile(ConnectionProfile connectionProfile) {
        ConnectionProfile connectionProfile1 = MockTcpTransport.resolveConnectionProfile((ConnectionProfile)connectionProfile, (ConnectionProfile)this.defaultConnectionProfile);
        ConnectionProfile.Builder builder = new ConnectionProfile.Builder();
        HashSet allTypesWithConnection = new HashSet();
        HashSet allTypesWithoutConnection = new HashSet();
        for (ConnectionProfile.ConnectionTypeHandle handle : connectionProfile1.getHandles()) {
            Set types = handle.getTypes();
            if (handle.length > 0) {
                allTypesWithConnection.addAll(types);
                continue;
            }
            allTypesWithoutConnection.addAll(types);
        }
        builder.addConnections(1, allTypesWithConnection.toArray(new TransportRequestOptions.Type[0]));
        if (!allTypesWithoutConnection.isEmpty()) {
            builder.addConnections(0, allTypesWithoutConnection.toArray(new TransportRequestOptions.Type[0]));
        }
        builder.setHandshakeTimeout(connectionProfile1.getHandshakeTimeout());
        builder.setConnectTimeout(connectionProfile1.getConnectTimeout());
        return builder.build();
    }

    private void configureSocket(Socket socket) throws SocketException {
        ByteSizeValue tcpReceiveBufferSize;
        socket.setTcpNoDelay((Boolean)TCP_NO_DELAY.get(this.settings));
        ByteSizeValue tcpSendBufferSize = (ByteSizeValue)TCP_SEND_BUFFER_SIZE.get(this.settings);
        if (tcpSendBufferSize.getBytes() > 0L) {
            socket.setSendBufferSize(tcpSendBufferSize.bytesAsInt());
        }
        if ((tcpReceiveBufferSize = (ByteSizeValue)TCP_RECEIVE_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
            socket.setReceiveBufferSize(tcpReceiveBufferSize.bytesAsInt());
        }
        socket.setReuseAddress((Boolean)TCP_REUSE_ADDRESS.get(this.settings));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() {
        boolean success = false;
        try {
            if (((Boolean)NetworkService.NETWORK_SERVER.get(this.settings)).booleanValue()) {
                for (TcpTransport.ProfileSettings profileSettings : this.profileSettings) {
                    this.bindServer(profileSettings);
                }
            }
            super.doStart();
            success = true;
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopInternal() {
        ThreadPool.terminate((ExecutorService)this.executor, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        Set<MockChannel> set = this.openChannels;
        synchronized (set) {
            assert (this.openChannels.isEmpty()) : "there are still open channels: " + this.openChannels;
        }
    }

    protected Version getCurrentVersion() {
        return this.mockVersion;
    }

    static {
        ConnectionProfile.Builder builder = new ConnectionProfile.Builder();
        builder.addConnections(1, new TransportRequestOptions.Type[]{TransportRequestOptions.Type.BULK, TransportRequestOptions.Type.PING, TransportRequestOptions.Type.RECOVERY, TransportRequestOptions.Type.REG, TransportRequestOptions.Type.STATE});
        LIGHT_PROFILE = builder.build();
    }

    public final class MockChannel
    implements Closeable,
    TcpChannel {
        private final AtomicBoolean isOpen = new AtomicBoolean(true);
        private final InetSocketAddress localAddress;
        private final ServerSocket serverSocket;
        private final Set<MockChannel> workerChannels = Collections.newSetFromMap(new ConcurrentHashMap());
        private final Socket activeChannel;
        private final String profile;
        private final CancellableThreads cancellableThreads = new CancellableThreads();
        private final Closeable onClose;
        private final CompletableFuture<Void> closeFuture = new CompletableFuture();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MockChannel(Socket socket, InetSocketAddress localAddress, String profile, Consumer<MockChannel> onClose) {
            this.localAddress = localAddress;
            this.activeChannel = socket;
            this.serverSocket = null;
            this.profile = profile;
            this.onClose = () -> onClose.accept(this);
            Set set = MockTcpTransport.this.openChannels;
            synchronized (set) {
                MockTcpTransport.this.openChannels.add(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MockChannel(ServerSocket serverSocket, String profile) {
            this.localAddress = (InetSocketAddress)serverSocket.getLocalSocketAddress();
            this.serverSocket = serverSocket;
            this.profile = profile;
            this.activeChannel = null;
            this.onClose = null;
            Set set = MockTcpTransport.this.openChannels;
            synchronized (set) {
                MockTcpTransport.this.openChannels.add(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void accept(Executor executor) throws IOException {
            while (this.isOpen.get()) {
                Socket incomingSocket = this.serverSocket.accept();
                MockChannel incomingChannel = null;
                try {
                    MockTcpTransport.this.configureSocket(incomingSocket);
                    MockChannel mockChannel = this;
                    synchronized (mockChannel) {
                        if (this.isOpen.get()) {
                            incomingChannel = new MockChannel(incomingSocket, new InetSocketAddress(incomingSocket.getLocalAddress(), incomingSocket.getPort()), this.profile, this.workerChannels::remove);
                            MockTcpTransport.this.serverAcceptedChannel(incomingChannel);
                            this.workerChannels.add(incomingChannel);
                            incomingChannel.loopRead(executor);
                            incomingSocket = null;
                            incomingChannel = null;
                        }
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{incomingSocket, incomingChannel});
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{incomingSocket, incomingChannel});
            }
        }

        public void loopRead(Executor executor) {
            executor.execute((Runnable)new AbstractRunnable(){

                public void onFailure(Exception e) {
                    if (MockChannel.this.isOpen.get()) {
                        try {
                            MockTcpTransport.this.onException(MockChannel.this, e);
                        }
                        catch (Exception ex) {
                            MockTcpTransport.this.logger.warn("failed on handling exception", (Throwable)ex);
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{MockChannel.this});
                        }
                    }
                }

                protected void doRun() throws Exception {
                    InputStreamStreamInput input = new InputStreamStreamInput((InputStream)new BufferedInputStream(MockChannel.this.activeChannel.getInputStream()));
                    while (MockChannel.this.isOpen.get() && !Thread.currentThread().isInterrupted()) {
                        MockChannel.this.cancellableThreads.executeIO(() -> this.lambda$doRun$0((StreamInput)input));
                    }
                }

                private /* synthetic */ void lambda$doRun$0(StreamInput input) throws IOException, InterruptedException {
                    MockTcpTransport.this.readMessage(MockChannel.this, input);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void close0() throws IOException {
            if (this.isOpen.compareAndSet(true, false)) {
                boolean removedChannel;
                Set set = MockTcpTransport.this.openChannels;
                synchronized (set) {
                    removedChannel = MockTcpTransport.this.openChannels.remove(this);
                }
                IOUtils.close((Closeable[])new Closeable[]{this.serverSocket, this.activeChannel, () -> IOUtils.close(this.workerChannels), () -> this.cancellableThreads.cancel("channel closed"), this.onClose});
                assert (removedChannel) : "Channel was not removed or removed twice?";
            }
        }

        public String toString() {
            return "MockChannel{profile='" + this.profile + '\'' + ", isOpen=" + this.isOpen + ", localAddress=" + this.localAddress + ", isServerSocket=" + (this.serverSocket != null) + '}';
        }

        @Override
        public void close() {
            try {
                this.close0();
                this.closeFuture.complete(null);
            }
            catch (IOException e) {
                this.closeFuture.completeExceptionally(e);
            }
        }

        public void addCloseListener(ActionListener<Void> listener) {
            this.closeFuture.whenComplete(ActionListener.toBiConsumer(listener));
        }

        public void setSoLinger(int value) throws IOException {
            if (this.activeChannel != null && !this.activeChannel.isClosed()) {
                this.activeChannel.setSoLinger(true, value);
            }
        }

        public boolean isOpen() {
            return this.isOpen.get();
        }

        public InetSocketAddress getLocalAddress() {
            return this.localAddress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendMessage(BytesReference reference, ActionListener<Void> listener) {
            try {
                MockChannel mockChannel = this;
                synchronized (mockChannel) {
                    BufferedOutputStream outputStream = new BufferedOutputStream(this.activeChannel.getOutputStream());
                    reference.writeTo((OutputStream)outputStream);
                    ((OutputStream)outputStream).flush();
                }
                listener.onResponse(null);
            }
            catch (IOException e) {
                listener.onFailure((Exception)e);
                MockTcpTransport.this.onException(this, e);
            }
        }
    }
}

