/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio;

import java.io.IOException;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.transport.nio.channel.NioChannel;

public abstract class EventHandler {
    protected final Logger logger;

    public EventHandler(Logger logger) {
        this.logger = logger;
    }

    void selectException(IOException exception) {
        this.logger.warn((Message)new ParameterizedMessage("io exception during select [thread={}]", (Object)Thread.currentThread().getName()), (Throwable)exception);
    }

    void closeSelectorException(IOException exception) {
        this.logger.warn((Message)new ParameterizedMessage("io exception while closing selector [thread={}]", (Object)Thread.currentThread().getName()), (Throwable)exception);
    }

    void uncaughtException(Exception exception) {
        Thread thread = Thread.currentThread();
        thread.getUncaughtExceptionHandler().uncaughtException(thread, exception);
    }

    void handleClose(NioChannel channel) {
        try {
            channel.closeFromSelector();
        }
        catch (IOException e) {
            this.closeException(channel, e);
        }
        assert (!channel.isOpen()) : "Should always be done as we are on the selector thread";
    }

    void closeException(NioChannel channel, Exception exception) {
        this.logger.debug(() -> new ParameterizedMessage("exception while closing channel: {}", (Object)channel), (Throwable)exception);
    }

    void genericChannelException(NioChannel channel, Exception exception) {
        this.logger.debug(() -> new ParameterizedMessage("exception while handling event for channel: {}", (Object)channel), (Throwable)exception);
    }
}

