/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio.channel;

import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.SocketChannel;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.nio.SocketSelector;
import org.elasticsearch.transport.nio.channel.NioSocketChannel;

public class TcpNioSocketChannel
extends NioSocketChannel
implements TcpChannel {
    public TcpNioSocketChannel(SocketChannel socketChannel, SocketSelector selector) throws IOException {
        super(socketChannel, selector);
    }

    public void sendMessage(BytesReference reference, ActionListener<Void> listener) {
        this.getWriteContext().sendMessage(reference, listener);
    }

    public void setSoLinger(int value) throws IOException {
        if (this.isOpen()) {
            ((SocketChannel)this.getRawChannel()).setOption((SocketOption)StandardSocketOptions.SO_LINGER, (Object)value);
        }
    }

    @Override
    public String toString() {
        return "TcpNioSocketChannel{localAddress=" + this.getLocalAddress() + ", remoteAddress=" + this.getRemoteAddress() + '}';
    }
}

