/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.IntConsumer;
import org.apache.lucene.index.AssertingDirectoryReader;
import org.apache.lucene.index.CompositeReaderContext;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.AssertingIndexSearcher;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Weight;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.index.ElasticsearchDirectoryReader;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.MockBigArrays;
import org.elasticsearch.common.util.MockPageCacheRecycler;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.cache.bitset.BitsetFilterCache;
import org.elasticsearch.index.cache.query.DisabledQueryCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.support.NestedScope;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.NoneCircuitBreakerService;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCache;
import org.elasticsearch.mock.orig.Mockito;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.MultiBucketConsumerService;
import org.elasticsearch.search.aggregations.SearchContextAggregations;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.subphase.DocValueFieldsFetchSubPhase;
import org.elasticsearch.search.fetch.subphase.FetchSourceSubPhase;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.InternalAggregationTestCase;
import org.junit.After;
import org.mockito.Matchers;

public abstract class AggregatorTestCase
extends ESTestCase {
    private static final String NESTEDFIELD_PREFIX = "nested_";
    private List<Releasable> releasables = new ArrayList<Releasable>();
    private static final String TYPE_NAME = "type";

    protected AggregatorFactory<?> createAggregatorFactory(AggregationBuilder aggregationBuilder, IndexSearcher indexSearcher, MappedFieldType ... fieldTypes) throws IOException {
        return this.createAggregatorFactory(aggregationBuilder, indexSearcher, this.createIndexSettings(), new MultiBucketConsumerService.MultiBucketConsumer(100000), fieldTypes);
    }

    protected AggregatorFactory<?> createAggregatorFactory(AggregationBuilder aggregationBuilder, IndexSearcher indexSearcher, IndexSettings indexSettings, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer, MappedFieldType ... fieldTypes) throws IOException {
        return this.createAggregatorFactory(null, aggregationBuilder, indexSearcher, indexSettings, bucketConsumer, fieldTypes);
    }

    protected AggregatorFactory<?> createAggregatorFactory(Query query, AggregationBuilder aggregationBuilder, IndexSearcher indexSearcher, IndexSettings indexSettings, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer, MappedFieldType ... fieldTypes) throws IOException {
        SearchContext searchContext = this.createSearchContext(indexSearcher, indexSettings);
        NoneCircuitBreakerService circuitBreakerService = new NoneCircuitBreakerService();
        org.mockito.Mockito.when((Object)searchContext.aggregations()).thenReturn((Object)new SearchContextAggregations(AggregatorFactories.EMPTY, bucketConsumer));
        org.mockito.Mockito.when((Object)searchContext.bigArrays()).thenReturn((Object)new MockBigArrays(new MockPageCacheRecycler(Settings.EMPTY), (CircuitBreakerService)circuitBreakerService));
        org.mockito.Mockito.when((Object)searchContext.query()).thenReturn((Object)query);
        MapperService mapperService = this.mapperServiceMock();
        org.mockito.Mockito.when((Object)mapperService.getIndexSettings()).thenReturn((Object)indexSettings);
        org.mockito.Mockito.when((Object)mapperService.hasNested()).thenReturn((Object)false);
        org.mockito.Mockito.when((Object)mapperService.types()).thenReturn(Collections.singleton(TYPE_NAME));
        org.mockito.Mockito.when((Object)searchContext.mapperService()).thenReturn((Object)mapperService);
        IndexFieldDataService ifds = new IndexFieldDataService(indexSettings, new IndicesFieldDataCache(Settings.EMPTY, new IndexFieldDataCache.Listener(){}), (CircuitBreakerService)circuitBreakerService, mapperService);
        org.mockito.Mockito.when((Object)searchContext.getForField((MappedFieldType)Mockito.any(MappedFieldType.class))).thenAnswer(invocationOnMock -> ifds.getForField((MappedFieldType)invocationOnMock.getArguments()[0]));
        SearchLookup searchLookup = new SearchLookup(mapperService, arg_0 -> ((IndexFieldDataService)ifds).getForField(arg_0), new String[]{TYPE_NAME});
        org.mockito.Mockito.when((Object)searchContext.lookup()).thenReturn((Object)searchLookup);
        QueryShardContext queryShardContext = this.queryShardContextMock(mapperService, fieldTypes, (CircuitBreakerService)circuitBreakerService);
        org.mockito.Mockito.when((Object)queryShardContext.getIndexSettings()).thenReturn((Object)indexSettings);
        org.mockito.Mockito.when((Object)searchContext.getQueryShardContext()).thenReturn((Object)queryShardContext);
        for (MappedFieldType fieldType : fieldTypes) {
            org.mockito.Mockito.when((Object)searchContext.smartNameFieldType(fieldType.name())).thenReturn((Object)fieldType);
        }
        return aggregationBuilder.build(searchContext, null);
    }

    protected <A extends Aggregator> A createAggregator(AggregationBuilder aggregationBuilder, IndexSearcher indexSearcher, MappedFieldType ... fieldTypes) throws IOException {
        return this.createAggregator(aggregationBuilder, indexSearcher, this.createIndexSettings(), new MultiBucketConsumerService.MultiBucketConsumer(100000), fieldTypes);
    }

    protected <A extends Aggregator> A createAggregator(Query query, AggregationBuilder aggregationBuilder, IndexSearcher indexSearcher, IndexSettings indexSettings, MappedFieldType ... fieldTypes) throws IOException {
        return this.createAggregator(query, aggregationBuilder, indexSearcher, indexSettings, new MultiBucketConsumerService.MultiBucketConsumer(100000), fieldTypes);
    }

    protected <A extends Aggregator> A createAggregator(Query query, AggregationBuilder aggregationBuilder, IndexSearcher indexSearcher, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer, MappedFieldType ... fieldTypes) throws IOException {
        return this.createAggregator(query, aggregationBuilder, indexSearcher, this.createIndexSettings(), bucketConsumer, fieldTypes);
    }

    protected <A extends Aggregator> A createAggregator(AggregationBuilder aggregationBuilder, IndexSearcher indexSearcher, IndexSettings indexSettings, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer, MappedFieldType ... fieldTypes) throws IOException {
        return this.createAggregator(null, aggregationBuilder, indexSearcher, indexSettings, bucketConsumer, fieldTypes);
    }

    protected <A extends Aggregator> A createAggregator(Query query, AggregationBuilder aggregationBuilder, IndexSearcher indexSearcher, IndexSettings indexSettings, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer, MappedFieldType ... fieldTypes) throws IOException {
        Aggregator aggregator = this.createAggregatorFactory(query, aggregationBuilder, indexSearcher, indexSettings, bucketConsumer, fieldTypes).create(null, true);
        return (A)aggregator;
    }

    protected SearchContext createSearchContext(IndexSearcher indexSearcher, IndexSettings indexSettings) {
        Engine.Searcher searcher = new Engine.Searcher("aggregator_test", indexSearcher);
        DisabledQueryCache queryCache = new DisabledQueryCache(indexSettings);
        QueryCachingPolicy queryCachingPolicy = new QueryCachingPolicy(){

            public void onUse(Query query) {
            }

            public boolean shouldCache(Query query) throws IOException {
                return false;
            }
        };
        ContextIndexSearcher contextIndexSearcher = new ContextIndexSearcher(searcher, (QueryCache)queryCache, queryCachingPolicy);
        SearchContext searchContext = (SearchContext)org.mockito.Mockito.mock(SearchContext.class);
        org.mockito.Mockito.when((Object)searchContext.numberOfShards()).thenReturn((Object)1);
        org.mockito.Mockito.when((Object)searchContext.searcher()).thenReturn((Object)contextIndexSearcher);
        org.mockito.Mockito.when((Object)searchContext.fetchPhase()).thenReturn((Object)new FetchPhase(Arrays.asList(new FetchSourceSubPhase(), new DocValueFieldsFetchSubPhase())));
        org.mockito.Mockito.when((Object)searchContext.getObjectMapper(Matchers.anyString())).thenAnswer(invocation -> {
            String fieldName = (String)invocation.getArguments()[0];
            if (fieldName.startsWith(NESTEDFIELD_PREFIX)) {
                Mapper.BuilderContext context = new Mapper.BuilderContext(indexSettings.getSettings(), new ContentPath());
                return new ObjectMapper.Builder(fieldName).nested(ObjectMapper.Nested.newNested((boolean)false, (boolean)false)).build(context);
            }
            return null;
        });
        org.mockito.Mockito.when((Object)searchContext.bitsetFilterCache()).thenReturn((Object)new BitsetFilterCache(indexSettings, (BitsetFilterCache.Listener)org.mockito.Mockito.mock(BitsetFilterCache.Listener.class)));
        ((SearchContext)org.mockito.Mockito.doAnswer(invocation -> {
            this.releasables.add((Releasable)invocation.getArguments()[0]);
            return null;
        }).when((Object)searchContext)).addReleasable((Releasable)Matchers.anyObject(), (SearchContext.Lifetime)Matchers.anyObject());
        return searchContext;
    }

    protected IndexSettings createIndexSettings() {
        return new IndexSettings(IndexMetaData.builder((String)"_index").settings(Settings.builder().put("index.version.created", Version.CURRENT)).numberOfShards(1).numberOfReplicas(0).creationDate(System.currentTimeMillis()).build(), Settings.EMPTY);
    }

    protected MapperService mapperServiceMock() {
        return (MapperService)org.mockito.Mockito.mock(MapperService.class);
    }

    protected QueryShardContext queryShardContextMock(MapperService mapperService, MappedFieldType[] fieldTypes, CircuitBreakerService circuitBreakerService) {
        QueryShardContext queryShardContext = (QueryShardContext)org.mockito.Mockito.mock(QueryShardContext.class);
        org.mockito.Mockito.when((Object)queryShardContext.getMapperService()).thenReturn((Object)mapperService);
        for (MappedFieldType fieldType : fieldTypes) {
            org.mockito.Mockito.when((Object)queryShardContext.fieldMapper(fieldType.name())).thenReturn((Object)fieldType);
            org.mockito.Mockito.when((Object)queryShardContext.getForField(fieldType)).then(invocation -> fieldType.fielddataBuilder(mapperService.getIndexSettings().getIndex().getName()).build(mapperService.getIndexSettings(), fieldType, (IndexFieldDataCache)new IndexFieldDataCache.None(), circuitBreakerService, mapperService));
        }
        NestedScope nestedScope = new NestedScope();
        org.mockito.Mockito.when((Object)queryShardContext.isFilter()).thenCallRealMethod();
        ((QueryShardContext)Mockito.doCallRealMethod().when((Object)queryShardContext)).setIsFilter(Matchers.anyBoolean());
        org.mockito.Mockito.when((Object)queryShardContext.nestedScope()).thenReturn((Object)nestedScope);
        return queryShardContext;
    }

    protected <A extends InternalAggregation, C extends Aggregator> A search(IndexSearcher searcher, Query query, AggregationBuilder builder, MappedFieldType ... fieldTypes) throws IOException {
        return this.search(searcher, query, builder, 100000, fieldTypes);
    }

    protected <A extends InternalAggregation, C extends Aggregator> A search(IndexSearcher searcher, Query query, AggregationBuilder builder, int maxBucket, MappedFieldType ... fieldTypes) throws IOException {
        MultiBucketConsumerService.MultiBucketConsumer bucketConsumer = new MultiBucketConsumerService.MultiBucketConsumer(maxBucket);
        A a = this.createAggregator(query, builder, searcher, bucketConsumer, fieldTypes);
        a.preCollection();
        searcher.search(query, a);
        a.postCollection();
        InternalAggregation internalAgg = a.buildAggregation(0L);
        InternalAggregationTestCase.assertMultiBucketConsumer((Aggregation)internalAgg, bucketConsumer);
        return (A)internalAgg;
    }

    protected <A extends InternalAggregation, C extends Aggregator> A searchAndReduce(IndexSearcher searcher, Query query, AggregationBuilder builder, MappedFieldType ... fieldTypes) throws IOException {
        return this.searchAndReduce(searcher, query, builder, 100000, fieldTypes);
    }

    protected <A extends InternalAggregation, C extends Aggregator> A searchAndReduce(IndexSearcher searcher, Query query, AggregationBuilder builder, int maxBucket, MappedFieldType ... fieldTypes) throws IOException {
        ShardSearcher[] subSearchers;
        IndexReaderContext ctx = searcher.getTopReaderContext();
        if (ctx instanceof LeafReaderContext) {
            subSearchers = new ShardSearcher[]{new ShardSearcher((LeafReaderContext)ctx, ctx)};
        } else {
            CompositeReaderContext compCTX = (CompositeReaderContext)ctx;
            int size = compCTX.leaves().size();
            subSearchers = new ShardSearcher[size];
            for (int searcherIDX = 0; searcherIDX < subSearchers.length; ++searcherIDX) {
                LeafReaderContext leave = (LeafReaderContext)compCTX.leaves().get(searcherIDX);
                subSearchers[searcherIDX] = new ShardSearcher(leave, (IndexReaderContext)compCTX);
            }
        }
        ArrayList<InternalAggregation> aggs = new ArrayList<InternalAggregation>();
        Query rewritten = searcher.rewrite(query);
        Weight weight = searcher.createWeight(rewritten, true, 1.0f);
        MultiBucketConsumerService.MultiBucketConsumer bucketConsumer = new MultiBucketConsumerService.MultiBucketConsumer(maxBucket);
        A root = this.createAggregator(query, builder, searcher, bucketConsumer, fieldTypes);
        for (ShardSearcher subSearcher : subSearchers) {
            MultiBucketConsumerService.MultiBucketConsumer shardBucketConsumer = new MultiBucketConsumerService.MultiBucketConsumer(maxBucket);
            A a = this.createAggregator(query, builder, (IndexSearcher)subSearcher, shardBucketConsumer, fieldTypes);
            a.preCollection();
            subSearcher.search(weight, (Collector)a);
            a.postCollection();
            InternalAggregation agg = a.buildAggregation(0L);
            aggs.add(agg);
            InternalAggregationTestCase.assertMultiBucketConsumer((Aggregation)agg, shardBucketConsumer);
        }
        if (aggs.isEmpty()) {
            return null;
        }
        if (AggregatorTestCase.randomBoolean() && aggs.size() > 1) {
            int toReduceSize = aggs.size();
            Collections.shuffle(aggs, AggregatorTestCase.random());
            int r = AggregatorTestCase.randomIntBetween(1, toReduceSize);
            List toReduce = aggs.subList(0, r);
            MultiBucketConsumerService.MultiBucketConsumer reduceBucketConsumer = new MultiBucketConsumerService.MultiBucketConsumer(maxBucket);
            InternalAggregation.ReduceContext context = new InternalAggregation.ReduceContext(root.context().bigArrays(), null, (IntConsumer)reduceBucketConsumer, false);
            InternalAggregation reduced = ((InternalAggregation)aggs.get(0)).doReduce(toReduce, context);
            InternalAggregationTestCase.assertMultiBucketConsumer((Aggregation)reduced, reduceBucketConsumer);
            aggs = new ArrayList(aggs.subList(r, toReduceSize));
            aggs.add(reduced);
        }
        MultiBucketConsumerService.MultiBucketConsumer reduceBucketConsumer = new MultiBucketConsumerService.MultiBucketConsumer(maxBucket);
        InternalAggregation.ReduceContext context = new InternalAggregation.ReduceContext(root.context().bigArrays(), null, (IntConsumer)reduceBucketConsumer, true);
        InternalAggregation internalAgg = ((InternalAggregation)aggs.get(0)).doReduce(aggs, context);
        InternalAggregationTestCase.assertMultiBucketConsumer((Aggregation)internalAgg, reduceBucketConsumer);
        return (A)internalAgg;
    }

    protected static DirectoryReader wrap(DirectoryReader directoryReader) throws IOException {
        return ElasticsearchDirectoryReader.wrap((DirectoryReader)directoryReader, (ShardId)new ShardId(new Index("_index", "_na_"), 0));
    }

    protected static IndexSearcher newIndexSearcher(IndexReader indexReader) {
        if (AggregatorTestCase.randomBoolean()) {
            return new AssertingIndexSearcher(AggregatorTestCase.random(), indexReader);
        }
        return new IndexSearcher(indexReader);
    }

    protected static IndexReader maybeWrapReaderEs(DirectoryReader reader) throws IOException {
        if (AggregatorTestCase.randomBoolean()) {
            return new AssertingDirectoryReader(reader);
        }
        return reader;
    }

    @After
    private void cleanupReleasables() {
        Releasables.close(this.releasables);
        this.releasables.clear();
    }

    private static class ShardSearcher
    extends IndexSearcher {
        private final List<LeafReaderContext> ctx;

        ShardSearcher(LeafReaderContext ctx, IndexReaderContext parent) {
            super(parent);
            this.ctx = Collections.singletonList(ctx);
        }

        public void search(Weight weight, Collector collector) throws IOException {
            this.search(this.ctx, weight, collector);
        }

        public String toString() {
            return "ShardSearcher(" + this.ctx.get(0) + ")";
        }
    }
}

