/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.elasticsearch.common.CheckedBiFunction;
import org.elasticsearch.common.CheckedFunction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.test.ESTestCase;
import org.elasticsearch.test.XContentTestUtils;
import org.elasticsearch.test.hamcrest.ElasticsearchAssertions;

public abstract class AbstractXContentTestCase<T extends ToXContent>
extends ESTestCase {
    protected static final int NUMBER_OF_TEST_RUNS = 20;

    public static <T extends ToXContent> void testFromXContent(int numberOfTestRuns, Supplier<T> instanceSupplier, boolean supportsUnknownFields, String[] shuffleFieldsExceptions, Predicate<String> randomFieldsExcludeFilter, CheckedBiFunction<XContent, BytesReference, XContentParser, IOException> createParserFunction, CheckedFunction<XContentParser, T, IOException> parseFunction, BiConsumer<T, T> assertEqualsConsumer, boolean assertToXContentEquivalence) throws IOException {
        for (int runs = 0; runs < numberOfTestRuns; ++runs) {
            ToXContent testInstance = (ToXContent)instanceSupplier.get();
            XContentType xContentType = AbstractXContentTestCase.randomFrom(XContentType.values());
            BytesReference shuffled = AbstractXContentTestCase.toShuffledXContent(testInstance, xContentType, ToXContent.EMPTY_PARAMS, false, createParserFunction, shuffleFieldsExceptions);
            BytesReference withRandomFields = supportsUnknownFields ? XContentTestUtils.insertRandomFields(xContentType, shuffled, randomFieldsExcludeFilter, AbstractXContentTestCase.random()) : shuffled;
            XContentParser parser = (XContentParser)createParserFunction.apply((Object)XContentFactory.xContent((XContentType)xContentType), (Object)withRandomFields);
            ToXContent parsed = (ToXContent)parseFunction.apply((Object)parser);
            assertEqualsConsumer.accept(testInstance, parsed);
            if (!assertToXContentEquivalence) continue;
            ElasticsearchAssertions.assertToXContentEquivalent(shuffled, XContentHelper.toXContent((ToXContent)parsed, (XContentType)xContentType, (boolean)false), xContentType);
        }
    }

    public final void testFromXContent() throws IOException {
        AbstractXContentTestCase.testFromXContent(20, this::createTestInstance, this.supportsUnknownFields(), this.getShuffleFieldsExceptions(), this.getRandomFieldsExcludeFilter(), (CheckedBiFunction<XContent, BytesReference, XContentParser, IOException>)((CheckedBiFunction)this::createParser), this::parseInstance, this::assertEqualInstances, this.assertToXContentEquivalence());
    }

    protected abstract T createTestInstance();

    private T parseInstance(XContentParser parser) throws IOException {
        T parsedInstance = this.doParseInstance(parser);
        AbstractXContentTestCase.assertNull((Object)parser.nextToken());
        return parsedInstance;
    }

    protected abstract T doParseInstance(XContentParser var1) throws IOException;

    protected void assertEqualInstances(T expectedInstance, T newInstance) {
        AbstractXContentTestCase.assertNotSame(newInstance, expectedInstance);
        AbstractXContentTestCase.assertEquals(expectedInstance, newInstance);
        AbstractXContentTestCase.assertEquals((long)expectedInstance.hashCode(), (long)newInstance.hashCode());
    }

    protected boolean assertToXContentEquivalence() {
        return true;
    }

    protected abstract boolean supportsUnknownFields();

    protected Predicate<String> getRandomFieldsExcludeFilter() {
        return field -> false;
    }

    protected String[] getShuffleFieldsExceptions() {
        return Strings.EMPTY_ARRAY;
    }
}

