/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.transport.nio.EventHandler;
import org.elasticsearch.transport.nio.SocketSelector;
import org.elasticsearch.transport.nio.channel.ChannelFactory;
import org.elasticsearch.transport.nio.channel.NioServerSocketChannel;
import org.elasticsearch.transport.nio.channel.NioSocketChannel;
import org.elasticsearch.transport.nio.channel.SelectionKeyUtils;

public class AcceptorEventHandler
extends EventHandler {
    private final Supplier<SocketSelector> selectorSupplier;

    public AcceptorEventHandler(Logger logger, Supplier<SocketSelector> selectorSupplier) {
        super(logger);
        this.selectorSupplier = selectorSupplier;
    }

    void serverChannelRegistered(NioServerSocketChannel nioServerSocketChannel) {
        SelectionKeyUtils.setAcceptInterested(nioServerSocketChannel);
    }

    void registrationException(NioServerSocketChannel channel, Exception exception) {
        this.logger.error((Message)new ParameterizedMessage("failed to register server channel: {}", (Object)channel), (Throwable)exception);
    }

    void acceptChannel(NioServerSocketChannel nioServerChannel) throws IOException {
        ChannelFactory channelFactory = nioServerChannel.getChannelFactory();
        SocketSelector selector = this.selectorSupplier.get();
        Object nioSocketChannel = channelFactory.acceptNioChannel(nioServerChannel, selector);
        nioServerChannel.getAcceptContext().accept((NioSocketChannel)nioSocketChannel);
    }

    void acceptException(NioServerSocketChannel nioServerChannel, Exception exception) {
        this.logger.debug(() -> new ParameterizedMessage("exception while accepting new channel from server channel: {}", (Object)nioServerChannel), (Throwable)exception);
    }
}

