/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.nio.AcceptorEventHandler;
import org.elasticsearch.transport.nio.InboundChannelBuffer;
import org.elasticsearch.transport.nio.NioGroup;
import org.elasticsearch.transport.nio.SocketEventHandler;
import org.elasticsearch.transport.nio.TcpReadHandler;
import org.elasticsearch.transport.nio.channel.NioServerSocketChannel;
import org.elasticsearch.transport.nio.channel.NioSocketChannel;
import org.elasticsearch.transport.nio.channel.TcpChannelFactory;
import org.elasticsearch.transport.nio.channel.TcpNioServerSocketChannel;
import org.elasticsearch.transport.nio.channel.TcpNioSocketChannel;
import org.elasticsearch.transport.nio.channel.TcpReadContext;
import org.elasticsearch.transport.nio.channel.TcpWriteContext;

public class NioTransport
extends TcpTransport {
    public static final String TRANSPORT_WORKER_THREAD_NAME_PREFIX = "es_nio_transport_worker";
    public static final String TRANSPORT_ACCEPTOR_THREAD_NAME_PREFIX = "es_nio_transport_acceptor";
    public static final Setting<Integer> NIO_WORKER_COUNT = new Setting("transport.nio.worker_count", s -> Integer.toString(EsExecutors.numberOfProcessors((Settings)s) * 2), s -> Setting.parseInt((String)s, (int)1, (String)"transport.nio.worker_count"), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Integer> NIO_ACCEPTOR_COUNT = Setting.intSetting((String)"transport.nio.acceptor_count", (int)1, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final PageCacheRecycler pageCacheRecycler;
    private final ConcurrentMap<String, TcpChannelFactory> profileToChannelFactory = ConcurrentCollections.newConcurrentMap();
    private volatile NioGroup nioGroup;
    private volatile TcpChannelFactory clientChannelFactory;

    public NioTransport(Settings settings, ThreadPool threadPool, NetworkService networkService, BigArrays bigArrays, PageCacheRecycler pageCacheRecycler, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService) {
        super("nio", settings, threadPool, bigArrays, circuitBreakerService, namedWriteableRegistry, networkService);
        this.pageCacheRecycler = pageCacheRecycler;
    }

    protected TcpNioServerSocketChannel bind(String name, InetSocketAddress address) throws IOException {
        TcpChannelFactory channelFactory = (TcpChannelFactory)this.profileToChannelFactory.get(name);
        return this.nioGroup.bindServerChannel(address, channelFactory);
    }

    protected TcpNioSocketChannel initiateChannel(DiscoveryNode node, TimeValue connectTimeout, ActionListener<Void> connectListener) throws IOException {
        TcpNioSocketChannel channel = this.nioGroup.openChannel(node.getAddress().address(), this.clientChannelFactory);
        channel.addConnectListener(connectListener);
        return channel;
    }

    protected void doStart() {
        boolean success = false;
        try {
            int acceptorCount = 0;
            boolean useNetworkServer = (Boolean)NetworkService.NETWORK_SERVER.get(this.settings);
            if (useNetworkServer) {
                acceptorCount = (Integer)NIO_ACCEPTOR_COUNT.get(this.settings);
            }
            this.nioGroup = new NioGroup(this.logger, EsExecutors.daemonThreadFactory((Settings)this.settings, (String)TRANSPORT_ACCEPTOR_THREAD_NAME_PREFIX), acceptorCount, AcceptorEventHandler::new, EsExecutors.daemonThreadFactory((Settings)this.settings, (String)TRANSPORT_WORKER_THREAD_NAME_PREFIX), (Integer)NIO_WORKER_COUNT.get(this.settings), this::getSocketEventHandler);
            TcpTransport.ProfileSettings clientProfileSettings = new TcpTransport.ProfileSettings(this.settings, "default");
            this.clientChannelFactory = new TcpChannelFactory(clientProfileSettings, this.getContextSetter("client"), this.getServerContextSetter());
            if (useNetworkServer) {
                for (TcpTransport.ProfileSettings profileSettings : this.profileSettings) {
                    String profileName = profileSettings.profileName;
                    Consumer<NioSocketChannel> contextSetter = this.getContextSetter(profileName);
                    TcpChannelFactory factory = new TcpChannelFactory(profileSettings, contextSetter, this.getServerContextSetter());
                    this.profileToChannelFactory.putIfAbsent(profileName, factory);
                    this.bindServer(profileSettings);
                }
            }
            super.doStart();
            success = true;
        }
        catch (IOException e) {
            throw new ElasticsearchException((Throwable)e);
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    protected void stopInternal() {
        try {
            this.nioGroup.close();
        }
        catch (Exception e) {
            this.logger.warn("unexpected exception while stopping nio group", (Throwable)e);
        }
        this.profileToChannelFactory.clear();
    }

    protected SocketEventHandler getSocketEventHandler(Logger logger) {
        return new SocketEventHandler(logger);
    }

    final void exceptionCaught(NioSocketChannel channel, Exception exception) {
        this.onException((TcpNioSocketChannel)channel, exception);
    }

    private Consumer<NioSocketChannel> getContextSetter(String profileName) {
        return c -> {
            Supplier<InboundChannelBuffer.Page> pageSupplier = () -> {
                Recycler.V bytes = this.pageCacheRecycler.bytePage(false);
                return new InboundChannelBuffer.Page(ByteBuffer.wrap((byte[])bytes.v()), (Releasable)bytes);
            };
            c.setContexts(new TcpReadContext((NioSocketChannel)c, new TcpReadHandler(profileName, this), new InboundChannelBuffer(pageSupplier)), new TcpWriteContext((NioSocketChannel)c), this::exceptionCaught);
        };
    }

    private void acceptChannel(NioSocketChannel channel) {
        this.serverAcceptedChannel((TcpNioSocketChannel)channel);
    }

    private Consumer<NioServerSocketChannel> getServerContextSetter() {
        return c -> c.setAcceptContext(this::acceptChannel);
    }
}

