/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.transport.nio.channel.NioSocketChannel;

public class WriteOperation {
    private final NioSocketChannel channel;
    private final ActionListener<Void> listener;
    private final ByteBuffer[] buffers;
    private final int[] offsets;
    private final int length;
    private int internalIndex;

    public WriteOperation(NioSocketChannel channel, BytesReference bytesReference, ActionListener<Void> listener) {
        this.channel = channel;
        this.listener = listener;
        this.buffers = WriteOperation.toByteBuffers(bytesReference);
        this.offsets = new int[this.buffers.length];
        int offset = 0;
        for (int i = 0; i < this.buffers.length; ++i) {
            ByteBuffer buffer = this.buffers[i];
            this.offsets[i] = offset;
            offset += buffer.remaining();
        }
        this.length = offset;
    }

    public ByteBuffer[] getByteBuffers() {
        return this.buffers;
    }

    public ActionListener<Void> getListener() {
        return this.listener;
    }

    public NioSocketChannel getChannel() {
        return this.channel;
    }

    public boolean isFullyFlushed() {
        return this.internalIndex == this.length;
    }

    public int flush() throws IOException {
        int written = this.channel.write(this.getBuffersToWrite());
        this.internalIndex += written;
        return written;
    }

    private ByteBuffer[] getBuffersToWrite() {
        int offsetIndex = this.getOffsetIndex(this.internalIndex);
        ByteBuffer[] postIndexBuffers = new ByteBuffer[this.buffers.length - offsetIndex];
        ByteBuffer firstBuffer = this.buffers[offsetIndex].duplicate();
        firstBuffer.position(this.internalIndex - this.offsets[offsetIndex]);
        postIndexBuffers[0] = firstBuffer;
        int j = 1;
        for (int i = offsetIndex + 1; i < this.buffers.length; ++i) {
            postIndexBuffers[j++] = this.buffers[i].duplicate();
        }
        return postIndexBuffers;
    }

    private int getOffsetIndex(int offset) {
        int i = Arrays.binarySearch(this.offsets, offset);
        return i < 0 ? -(i + 1) - 1 : i;
    }

    private static ByteBuffer[] toByteBuffers(BytesReference bytesReference) {
        BytesRefIterator byteRefIterator = bytesReference.iterator();
        try {
            BytesRef r;
            ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(3);
            while ((r = byteRefIterator.next()) != null) {
                buffers.add(ByteBuffer.wrap(r.bytes, r.offset, r.length));
            }
            return buffers.toArray(new ByteBuffer[buffers.size()]);
        }
        catch (IOException e) {
            throw new AssertionError("won't happen", e);
        }
    }
}

