/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio.channel;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NetworkChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.transport.nio.ESSelector;
import org.elasticsearch.transport.nio.channel.NioChannel;

public abstract class AbstractNioChannel<S extends SelectableChannel>
implements NioChannel {
    final S socketChannel;
    final AtomicBoolean isClosing = new AtomicBoolean(false);
    private final InetSocketAddress localAddress;
    private final CompletableFuture<Void> closeContext = new CompletableFuture();
    private final ESSelector selector;
    private SelectionKey selectionKey;

    AbstractNioChannel(S socketChannel, ESSelector selector) throws IOException {
        this.socketChannel = socketChannel;
        this.localAddress = (InetSocketAddress)((NetworkChannel)socketChannel).getLocalAddress();
        this.selector = selector;
    }

    @Override
    public boolean isOpen() {
        return !this.closeContext.isDone();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public void close() {
        if (this.isClosing.compareAndSet(false, true)) {
            this.selector.queueChannelClose(this);
        }
    }

    @Override
    public void closeFromSelector() throws IOException {
        assert (this.selector.isOnCurrentThread()) : "Should only call from selector thread";
        this.isClosing.set(true);
        if (!this.closeContext.isDone()) {
            try {
                this.closeRawChannel();
                this.closeContext.complete(null);
            }
            catch (IOException e) {
                this.closeContext.completeExceptionally(e);
                throw e;
            }
        }
    }

    @Override
    public void register() throws ClosedChannelException {
        this.setSelectionKey(((SelectableChannel)this.socketChannel).register(this.selector.rawSelector(), 0));
    }

    @Override
    public ESSelector getSelector() {
        return this.selector;
    }

    @Override
    public SelectionKey getSelectionKey() {
        return this.selectionKey;
    }

    public S getRawChannel() {
        return this.socketChannel;
    }

    @Override
    public void addCloseListener(ActionListener<Void> listener) {
        this.closeContext.whenComplete(ActionListener.toBiConsumer(listener));
    }

    void setSelectionKey(SelectionKey selectionKey) {
        this.selectionKey = selectionKey;
    }

    void closeRawChannel() throws IOException {
        ((AbstractInterruptibleChannel)this.socketChannel).close();
    }
}

