/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio.channel;

import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import org.elasticsearch.transport.nio.channel.NioChannel;
import org.elasticsearch.transport.nio.channel.NioServerSocketChannel;

public final class SelectionKeyUtils {
    private SelectionKeyUtils() {
    }

    public static void setWriteInterested(NioChannel channel) throws CancelledKeyException {
        SelectionKey selectionKey = channel.getSelectionKey();
        selectionKey.interestOps(selectionKey.interestOps() | 4);
    }

    public static void removeWriteInterested(NioChannel channel) throws CancelledKeyException {
        SelectionKey selectionKey = channel.getSelectionKey();
        selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFFB);
    }

    public static void setConnectAndReadInterested(NioChannel channel) throws CancelledKeyException {
        SelectionKey selectionKey = channel.getSelectionKey();
        selectionKey.interestOps(selectionKey.interestOps() | 8 | 1);
    }

    public static void removeConnectInterested(NioChannel channel) throws CancelledKeyException {
        SelectionKey selectionKey = channel.getSelectionKey();
        selectionKey.interestOps(selectionKey.interestOps() & 0xFFFFFFF7);
    }

    public static void setAcceptInterested(NioServerSocketChannel channel) {
        SelectionKey selectionKey = channel.getSelectionKey();
        selectionKey.interestOps(selectionKey.interestOps() | 0x10);
    }
}

