/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio.channel;

import java.io.IOException;
import java.io.StreamCorruptedException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.transport.TcpTransport;

public class TcpFrameDecoder {
    private static final long NINETY_PER_HEAP_SIZE = (long)((double)JvmInfo.jvmInfo().getMem().getHeapMax().getBytes() * 0.9);
    private static final int HEADER_SIZE = 6;
    private int expectedMessageLength = -1;

    public BytesReference decode(BytesReference bytesReference) throws IOException {
        if (bytesReference.length() >= 6) {
            int messageLength = this.readHeaderBuffer(bytesReference);
            int totalLength = messageLength + 6;
            if (totalLength > bytesReference.length()) {
                this.expectedMessageLength = totalLength;
                return null;
            }
            if (totalLength == bytesReference.length()) {
                this.expectedMessageLength = -1;
                return bytesReference;
            }
            this.expectedMessageLength = -1;
            return bytesReference.slice(0, totalLength);
        }
        return null;
    }

    public int expectedMessageLength() {
        return this.expectedMessageLength;
    }

    private int readHeaderBuffer(BytesReference headerBuffer) throws IOException {
        int messageLength;
        if (headerBuffer.get(0) != 69 || headerBuffer.get(1) != 83) {
            if (TcpFrameDecoder.appearsToBeHTTP(headerBuffer)) {
                throw new TcpTransport.HttpOnTransportException("This is not a HTTP port");
            }
            throw new StreamCorruptedException("invalid internal transport message format, got (" + Integer.toHexString(headerBuffer.get(0) & 0xFF) + "," + Integer.toHexString(headerBuffer.get(1) & 0xFF) + "," + Integer.toHexString(headerBuffer.get(2) & 0xFF) + "," + Integer.toHexString(headerBuffer.get(3) & 0xFF) + ")");
        }
        try (StreamInput input = headerBuffer.streamInput();){
            input.skip(2L);
            messageLength = input.readInt();
        }
        if (messageLength == -1) {
            return 0;
        }
        if (messageLength <= 0) {
            throw new StreamCorruptedException("invalid data length: " + messageLength);
        }
        if ((long)messageLength > NINETY_PER_HEAP_SIZE) {
            throw new IllegalArgumentException("transport content length received [" + new ByteSizeValue((long)messageLength) + "] exceeded [" + new ByteSizeValue(NINETY_PER_HEAP_SIZE) + "]");
        }
        return messageLength;
    }

    private static boolean appearsToBeHTTP(BytesReference headerBuffer) {
        return TcpFrameDecoder.bufferStartsWith(headerBuffer, "GET") || TcpFrameDecoder.bufferStartsWith(headerBuffer, "POST") || TcpFrameDecoder.bufferStartsWith(headerBuffer, "PUT") || TcpFrameDecoder.bufferStartsWith(headerBuffer, "HEAD") || TcpFrameDecoder.bufferStartsWith(headerBuffer, "DELETE") || TcpFrameDecoder.bufferStartsWith(headerBuffer, "OPTION") || TcpFrameDecoder.bufferStartsWith(headerBuffer, "PATCH") || TcpFrameDecoder.bufferStartsWith(headerBuffer, "TRACE");
    }

    private static boolean bufferStartsWith(BytesReference buffer, String method) {
        char[] chars = method.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (buffer.get(i) == chars[i]) continue;
            return false;
        }
        return true;
    }
}

