/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.Processor;

public class TestProcessor
implements Processor {
    private final String type;
    private final String tag;
    private final Consumer<IngestDocument> ingestDocumentConsumer;
    private final AtomicInteger invokedCounter = new AtomicInteger();

    public TestProcessor(Consumer<IngestDocument> ingestDocumentConsumer) {
        this(null, "test-processor", ingestDocumentConsumer);
    }

    public TestProcessor(String tag, String type, Consumer<IngestDocument> ingestDocumentConsumer) {
        this.ingestDocumentConsumer = ingestDocumentConsumer;
        this.type = type;
        this.tag = tag;
    }

    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        this.invokedCounter.incrementAndGet();
        this.ingestDocumentConsumer.accept(ingestDocument);
        return ingestDocument;
    }

    public String getType() {
        return this.type;
    }

    public String getTag() {
        return this.tag;
    }

    public int getInvokedCounter() {
        return this.invokedCounter.get();
    }

    public static final class Factory
    implements Processor.Factory {
        public TestProcessor create(Map<String, Processor.Factory> registry, String processorTag, Map<String, Object> config) throws Exception {
            return new TestProcessor(processorTag, "test-processor", ingestDocument -> {});
        }
    }
}

