/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.generators.RandomNumbers;
import com.carrotsearch.randomizedtesting.generators.RandomStrings;
import java.io.IOException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class BackgroundIndexer
implements AutoCloseable {
    private final Logger logger = LogManager.getLogger(this.getClass());
    final Thread[] writers;
    final Client client;
    final CountDownLatch stopLatch;
    final CopyOnWriteArrayList<Exception> failures;
    final AtomicBoolean stop = new AtomicBoolean(false);
    final AtomicLong idGenerator = new AtomicLong();
    final CountDownLatch startLatch = new CountDownLatch(1);
    final AtomicBoolean hasBudget = new AtomicBoolean(false);
    final Semaphore availableBudget = new Semaphore(0);
    final boolean useAutoGeneratedIDs;
    private final Set<String> ids = ConcurrentCollections.newConcurrentSet();
    private boolean assertNoFailuresOnStop = true;
    volatile int minFieldSize = 10;
    volatile int maxFieldSize = 140;

    public BackgroundIndexer(String index, String type, Client client) {
        this(index, type, client, -1);
    }

    public BackgroundIndexer(String index, String type, Client client, int numOfDocs) {
        this(index, type, client, numOfDocs, RandomizedTest.scaledRandomIntBetween((int)2, (int)5));
    }

    public BackgroundIndexer(String index, String type, Client client, int numOfDocs, int writerCount) {
        this(index, type, client, numOfDocs, writerCount, true, null);
    }

    public BackgroundIndexer(final String index, final String type, final Client client, int numOfDocs, int writerCount, boolean autoStart, Random random) {
        if (random == null) {
            random = RandomizedTest.getRandom();
        }
        this.client = client;
        this.useAutoGeneratedIDs = random.nextBoolean();
        this.failures = new CopyOnWriteArrayList();
        this.writers = new Thread[writerCount];
        this.stopLatch = new CountDownLatch(this.writers.length);
        this.logger.info("--> creating {} indexing threads (auto start: [{}], numOfDocs: [{}])", (Object)writerCount, (Object)autoStart, (Object)numOfDocs);
        for (int i = 0; i < this.writers.length; ++i) {
            final int indexerId = i;
            final boolean batch = random.nextBoolean();
            final Random threadRandom = new Random(random.nextLong());
            this.writers[i] = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long id = -1L;
                    try {
                        BackgroundIndexer.this.startLatch.await();
                        BackgroundIndexer.this.logger.info("**** starting indexing thread {}", (Object)indexerId);
                        while (!BackgroundIndexer.this.stop.get()) {
                            if (batch) {
                                int batchSize = threadRandom.nextInt(20) + 1;
                                if (BackgroundIndexer.this.hasBudget.get() && !BackgroundIndexer.this.availableBudget.tryAcquire(batchSize = Math.max(Math.min(batchSize, BackgroundIndexer.this.availableBudget.availablePermits()), 1), 250L, TimeUnit.MILLISECONDS)) continue;
                                BulkRequestBuilder bulkRequest = client.prepareBulk();
                                for (int i = 0; i < batchSize; ++i) {
                                    id = BackgroundIndexer.this.idGenerator.incrementAndGet();
                                    if (BackgroundIndexer.this.useAutoGeneratedIDs) {
                                        bulkRequest.add(client.prepareIndex(index, type).setSource(BackgroundIndexer.this.generateSource(id, threadRandom)));
                                        continue;
                                    }
                                    bulkRequest.add(client.prepareIndex(index, type, Long.toString(id)).setSource(BackgroundIndexer.this.generateSource(id, threadRandom)));
                                }
                                BulkResponse bulkResponse = (BulkResponse)bulkRequest.get();
                                for (BulkItemResponse bulkItemResponse : bulkResponse) {
                                    if (!bulkItemResponse.isFailed()) {
                                        boolean add = BackgroundIndexer.this.ids.add(bulkItemResponse.getId());
                                        assert (add) : "ID: " + bulkItemResponse.getId() + " already used";
                                        continue;
                                    }
                                    BackgroundIndexer.this.failures.add(bulkItemResponse.getFailure().getCause());
                                }
                                continue;
                            }
                            if (BackgroundIndexer.this.hasBudget.get() && !BackgroundIndexer.this.availableBudget.tryAcquire(250L, TimeUnit.MILLISECONDS)) continue;
                            id = BackgroundIndexer.this.idGenerator.incrementAndGet();
                            if (BackgroundIndexer.this.useAutoGeneratedIDs) {
                                IndexResponse indexResponse = (IndexResponse)client.prepareIndex(index, type).setSource(BackgroundIndexer.this.generateSource(id, threadRandom)).get();
                                boolean add = BackgroundIndexer.this.ids.add(indexResponse.getId());
                                assert (add) : "ID: " + indexResponse.getId() + " already used";
                                continue;
                            }
                            IndexResponse indexResponse = (IndexResponse)client.prepareIndex(index, type, Long.toString(id)).setSource(BackgroundIndexer.this.generateSource(id, threadRandom)).get();
                            boolean add = BackgroundIndexer.this.ids.add(indexResponse.getId());
                            assert (add) : "ID: " + indexResponse.getId() + " already used";
                        }
                        BackgroundIndexer.this.logger.info("**** done indexing thread {}  stop: {} numDocsIndexed: {}", (Object)indexerId, (Object)BackgroundIndexer.this.stop.get(), (Object)BackgroundIndexer.this.ids.size());
                    }
                    catch (Exception e) {
                        BackgroundIndexer.this.failures.add(e);
                        long docId = id;
                        BackgroundIndexer.this.logger.warn(() -> new ParameterizedMessage("**** failed indexing thread {} on doc id {}", (Object)indexerId, (Object)docId), (Throwable)e);
                    }
                    finally {
                        BackgroundIndexer.this.stopLatch.countDown();
                    }
                }
            };
            this.writers[i].start();
        }
        if (autoStart) {
            this.start(numOfDocs);
        }
    }

    private XContentBuilder generateSource(long id, Random random) throws IOException {
        int contentLength = RandomNumbers.randomIntBetween((Random)random, (int)this.minFieldSize, (int)this.maxFieldSize);
        StringBuilder text = new StringBuilder(contentLength);
        while (text.length() < contentLength) {
            int tokenLength = RandomNumbers.randomIntBetween((Random)random, (int)1, (int)Math.min(contentLength - text.length(), 10));
            text.append(" ").append(RandomStrings.randomRealisticUnicodeOfCodepointLength((Random)random, (int)tokenLength));
        }
        XContentBuilder builder = XContentFactory.smileBuilder();
        builder.startObject().field("test", "value" + id).field("text", text.toString()).field("id", id).endObject();
        return builder;
    }

    private void setBudget(int numOfDocs) {
        this.logger.debug("updating budget to [{}]", (Object)numOfDocs);
        if (numOfDocs >= 0) {
            this.hasBudget.set(true);
            this.availableBudget.release(numOfDocs);
        } else {
            this.hasBudget.set(false);
        }
    }

    public void start() {
        this.start(-1);
    }

    public void start(int numOfDocs) {
        assert (!this.stop.get()) : "background indexer can not be started after it has stopped";
        this.setBudget(numOfDocs);
        this.startLatch.countDown();
    }

    public void pauseIndexing() {
        this.availableBudget.drainPermits();
        this.setBudget(0);
    }

    public void continueIndexing() {
        this.continueIndexing(-1);
    }

    public void continueIndexing(int numOfDocs) {
        this.setBudget(numOfDocs);
    }

    public void stop() throws InterruptedException {
        if (this.stop.get()) {
            return;
        }
        this.stop.set(true);
        Assert.assertThat((String)"timeout while waiting for indexing threads to stop", (Object)this.stopLatch.await(6L, TimeUnit.MINUTES), (Matcher)Matchers.equalTo((Object)true));
        if (this.assertNoFailuresOnStop) {
            this.assertNoFailures();
        }
    }

    public long totalIndexedDocs() {
        return this.ids.size();
    }

    public Throwable[] getFailures() {
        return this.failures.toArray(new Throwable[this.failures.size()]);
    }

    public void assertNoFailures() {
        Assert.assertThat(this.failures, (Matcher)Matchers.emptyIterable());
    }

    public void setMinFieldSize(int fieldSize) {
        this.minFieldSize = fieldSize;
    }

    public void setMaxFieldSize(int fieldSize) {
        this.maxFieldSize = fieldSize;
    }

    public void setAssertNoFailuresOnStop(boolean assertNoFailuresOnStop) {
        this.assertNoFailuresOnStop = assertNoFailuresOnStop;
    }

    @Override
    public void close() throws Exception {
        this.stop();
    }

    public Client getClient() {
        return this.client;
    }

    public Set<String> getIds() {
        return this.ids;
    }
}

