/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.test.VersionUtils;
import org.elasticsearch.test.rest.yaml.Features;
import org.elasticsearch.test.rest.yaml.section.ParserUtils;

public class SkipSection {
    public static final SkipSection EMPTY = new SkipSection();
    private final Version lowerVersion;
    private final Version upperVersion;
    private final List<String> features;
    private final String reason;

    public static SkipSection parseIfNext(XContentParser parser) throws IOException {
        ParserUtils.advanceToFieldName(parser);
        if ("skip".equals(parser.currentName())) {
            SkipSection section = SkipSection.parse(parser);
            parser.nextToken();
            return section;
        }
        return EMPTY;
    }

    public static SkipSection parse(XContentParser parser) throws IOException {
        XContentParser.Token token;
        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("Expected [" + XContentParser.Token.START_OBJECT + ", found [" + parser.currentToken() + "], the skip section is not properly indented");
        }
        String currentFieldName = null;
        String version = null;
        String reason = null;
        ArrayList<String> features = new ArrayList<String>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("version".equals(currentFieldName)) {
                    version = parser.text();
                    continue;
                }
                if ("reason".equals(currentFieldName)) {
                    reason = parser.text();
                    continue;
                }
                if ("features".equals(currentFieldName)) {
                    features.add(parser.text());
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "field " + currentFieldName + " not supported within skip section", new Object[0]);
            }
            if (token != XContentParser.Token.START_ARRAY || !"features".equals(currentFieldName)) continue;
            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                features.add(parser.text());
            }
        }
        parser.nextToken();
        if (!Strings.hasLength(version) && features.isEmpty()) {
            throw new ParsingException(parser.getTokenLocation(), "version or features is mandatory within skip section", new Object[0]);
        }
        if (Strings.hasLength(version) && !Strings.hasLength(reason)) {
            throw new ParsingException(parser.getTokenLocation(), "reason is mandatory within skip version section", new Object[0]);
        }
        return new SkipSection(version, features, reason);
    }

    private SkipSection() {
        this.lowerVersion = null;
        this.upperVersion = null;
        this.features = new ArrayList<String>();
        this.reason = null;
    }

    public SkipSection(String versionRange, List<String> features, String reason) {
        assert (features != null);
        Version[] versions = SkipSection.parseVersionRange(versionRange);
        this.lowerVersion = versions[0];
        this.upperVersion = versions[1];
        this.features = features;
        this.reason = reason;
    }

    public Version getLowerVersion() {
        return this.lowerVersion;
    }

    public Version getUpperVersion() {
        return this.upperVersion;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public String getReason() {
        return this.reason;
    }

    public boolean skip(Version currentVersion) {
        if (this.isEmpty()) {
            return false;
        }
        boolean skip = this.lowerVersion != null && this.upperVersion != null && currentVersion.onOrAfter(this.lowerVersion) && currentVersion.onOrBefore(this.upperVersion);
        return skip |= !Features.areAllSupported(this.features);
    }

    public boolean isVersionCheck() {
        return this.features.isEmpty();
    }

    public boolean isEmpty() {
        return EMPTY.equals(this);
    }

    static Version[] parseVersionRange(String versionRange) {
        if (versionRange == null) {
            return new Version[]{null, null};
        }
        if (versionRange.trim().equals("all")) {
            return new Version[]{VersionUtils.getFirstVersion(), Version.CURRENT};
        }
        String[] skipVersions = versionRange.split("-");
        if (skipVersions.length > 2) {
            throw new IllegalArgumentException("version range malformed: " + versionRange);
        }
        String lower = skipVersions[0].trim();
        String upper = skipVersions[1].trim();
        return new Version[]{lower.isEmpty() ? VersionUtils.getFirstVersion() : Version.fromString((String)lower), upper.isEmpty() ? Version.CURRENT : Version.fromString((String)upper)};
    }

    public String getSkipMessage(String description) {
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("[").append(description).append("] skipped,");
        if (this.reason != null) {
            messageBuilder.append(" reason: [").append(this.getReason()).append("]");
        }
        if (!this.features.isEmpty()) {
            messageBuilder.append(" unsupported features ").append(this.getFeatures());
        }
        return messageBuilder.toString();
    }
}

