/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.elasticsearch.nio.EventHandler;
import org.elasticsearch.nio.NioSelector;
import org.elasticsearch.nio.SocketChannelContext;

public class TestingSocketEventHandler
extends EventHandler {
    private Set<SocketChannelContext> hasConnectedMap = Collections.newSetFromMap(new WeakHashMap());
    private Set<SocketChannelContext> hasConnectExceptionMap = Collections.newSetFromMap(new WeakHashMap());

    public TestingSocketEventHandler(Consumer<Exception> exceptionHandler, Supplier<NioSelector> selectorSupplier) {
        super(exceptionHandler, selectorSupplier);
    }

    public void handleConnect(SocketChannelContext context) throws IOException {
        assert (!this.hasConnectedMap.contains(context)) : "handleConnect should only be called is a channel is not yet connected";
        super.handleConnect(context);
        if (context.isConnectComplete()) {
            this.hasConnectedMap.add(context);
        }
    }

    public void connectException(SocketChannelContext context, Exception e) {
        assert (!this.hasConnectExceptionMap.contains(context)) : "connectException should only called at maximum once per channel";
        this.hasConnectExceptionMap.add(context);
        super.connectException(context, e);
    }
}

