/*
 * Decompiled with CFR 0.152.
 */
package org.emfjson.jackson.annotations;

import com.fasterxml.jackson.databind.DatabindContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.emfjson.jackson.databind.EMFContext;
import org.emfjson.jackson.resource.JsonResource;
import org.emfjson.jackson.utils.ValueReader;
import org.emfjson.jackson.utils.ValueWriter;

public class EcoreIdentityInfo {
    public static final String PROPERTY = "@id";
    private static final ValueReader<Object, String> defaultValueReader = (value, context) -> value.toString();
    private static final ValueWriter<EObject, Object> defaultValueWriter = (object, context) -> {
        Resource resource = EMFContext.getResource((DatabindContext)context, object);
        String id = resource instanceof JsonResource ? ((JsonResource)resource).getID((EObject)object) : EMFContext.getURI((DatabindContext)context, object).fragment();
        return id;
    };
    private final String property;
    private final ValueReader<Object, String> valueReader;
    private final ValueWriter<EObject, Object> valueWriter;

    public EcoreIdentityInfo() {
        this(null, null, null);
    }

    public EcoreIdentityInfo(String property) {
        this(property, null, null);
    }

    public EcoreIdentityInfo(String property, ValueReader<Object, String> valueReader) {
        this(property, valueReader, null);
    }

    public EcoreIdentityInfo(String property, ValueWriter<EObject, Object> valueWriter) {
        this(property, null, valueWriter);
    }

    public EcoreIdentityInfo(String property, ValueReader<Object, String> valueReader, ValueWriter<EObject, Object> valueWriter) {
        this.property = property == null ? PROPERTY : property;
        this.valueReader = valueReader == null ? defaultValueReader : valueReader;
        this.valueWriter = valueWriter == null ? defaultValueWriter : valueWriter;
    }

    public String getProperty() {
        return this.property;
    }

    public ValueReader<Object, String> getValueReader() {
        return this.valueReader;
    }

    public ValueWriter<EObject, Object> getValueWriter() {
        return this.valueWriter;
    }
}

