/*
 * Decompiled with CFR 0.152.
 */
package org.emfjson.jackson.annotations;

import com.fasterxml.jackson.databind.DatabindContext;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.emfjson.jackson.databind.EMFContext;
import org.emfjson.jackson.utils.ValueReader;
import org.emfjson.jackson.utils.ValueWriter;

public class EcoreTypeInfo {
    public static final String PROPERTY = "eClass";
    public static final ValueReader<String, EClass> defaultValueReader = (value, context) -> EMFContext.findEClass((DatabindContext)context, value);
    public static final ValueWriter<EClass, String> defaultValueWriter = (value, context) -> EMFContext.getURI((DatabindContext)context, (EObject)value).toString();
    public static final ValueReader<String, EClass> readByName = (value, context) -> EMFContext.findEClassByName((DatabindContext)context, value);
    public static final ValueWriter<EClass, String> writeByName = (value, context) -> value != null ? value.getName() : null;
    public static final ValueReader<String, EClass> readByClassName = (value, context) -> EMFContext.findEClassByQualifiedName((DatabindContext)context, value);
    public static final ValueWriter<EClass, String> writeByClassName = (value, context) -> value != null ? value.getInstanceClassName() : null;
    private final String property;
    private final ValueReader<String, EClass> valueReader;
    private final ValueWriter<EClass, String> valueWriter;

    public EcoreTypeInfo() {
        this(null, null, null);
    }

    public EcoreTypeInfo(String property) {
        this(property, null, null);
    }

    public EcoreTypeInfo(String property, ValueReader<String, EClass> valueReader) {
        this(property, valueReader, null);
    }

    public EcoreTypeInfo(String property, ValueWriter<EClass, String> valueWriter) {
        this(property, null, valueWriter);
    }

    public EcoreTypeInfo(String property, ValueReader<String, EClass> valueReader, ValueWriter<EClass, String> valueWriter) {
        this.property = property == null ? PROPERTY : property;
        this.valueReader = valueReader == null ? defaultValueReader : valueReader;
        this.valueWriter = valueWriter == null ? defaultValueWriter : valueWriter;
    }

    public String getProperty() {
        return this.property;
    }

    public ValueReader<String, EClass> getValueReader() {
        return this.valueReader;
    }

    public ValueWriter<EClass, String> getValueWriter() {
        return this.valueWriter;
    }

    public static EcoreTypeInfo create(String property, USE use) {
        switch (use) {
            case NAME: {
                return new EcoreTypeInfo(property, readByName, writeByName);
            }
            case CLASS: {
                return new EcoreTypeInfo(property, readByClassName, writeByClassName);
            }
        }
        return new EcoreTypeInfo(property, defaultValueReader, defaultValueWriter);
    }

    public static enum USE {
        URI,
        NAME,
        CLASS;

    }
}

