/*
 * Decompiled with CFR 0.152.
 */
package org.emfjson.jackson.annotations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.emfjson.jackson.annotations.EcoreTypeInfo;
import org.emfjson.jackson.databind.EMFContext;
import org.emfjson.jackson.utils.ValueReader;
import org.emfjson.jackson.utils.ValueWriter;

public class JsonAnnotations {
    private static final String EXTENDED_METADATA = "http:///org/eclipse/emf/ecore/util/ExtendedMetaData";

    public static String getElementName(ENamedElement element) {
        String value = JsonAnnotations.getValue(element, "JsonProperty", "value");
        if (value == null) {
            value = JsonAnnotations.getValue(element, EXTENDED_METADATA, "name");
        }
        return value == null ? element.getName() : value;
    }

    public static List<String> getAliases(ENamedElement element) {
        return JsonAnnotations.getValues(element, "JsonAlias", "value");
    }

    public static boolean shouldIgnore(EStructuralFeature feature) {
        return feature.getEAnnotation("JsonIgnore") != null;
    }

    public static EcoreTypeInfo getTypeProperty(EClassifier classifier) {
        String property = JsonAnnotations.getValue((ENamedElement)classifier, "JsonType", "property");
        String use = JsonAnnotations.getValue((ENamedElement)classifier, "JsonType", "use");
        ValueReader<String, EClass> valueReader = EcoreTypeInfo.defaultValueReader;
        ValueWriter<EClass, String> valueWriter = EcoreTypeInfo.defaultValueWriter;
        if (use != null) {
            EcoreTypeInfo.USE useType = EcoreTypeInfo.USE.valueOf(use.toUpperCase());
            if (useType == EcoreTypeInfo.USE.NAME) {
                valueReader = (value, context) -> {
                    EClass type;
                    EClass eClass = type = value != null && value.equalsIgnoreCase(classifier.getName()) ? (EClass)classifier : null;
                    if (type == null) {
                        type = EMFContext.findEClassByName(value, classifier.getEPackage());
                    }
                    return type;
                };
                valueWriter = (value, context) -> value.getName();
            } else if (useType == EcoreTypeInfo.USE.CLASS) {
                valueReader = (value, context) -> {
                    EClass type;
                    EClass eClass = type = value != null && value.equalsIgnoreCase(classifier.getInstanceClassName()) ? (EClass)classifier : null;
                    if (type == null) {
                        type = EMFContext.findEClassByQualifiedName(value, classifier.getEPackage());
                    }
                    return type;
                };
                valueWriter = (value, context) -> value.getInstanceClassName();
            } else {
                valueReader = EcoreTypeInfo.defaultValueReader;
                valueWriter = EcoreTypeInfo.defaultValueWriter;
            }
        }
        return property != null ? new EcoreTypeInfo(property, valueReader, valueWriter) : null;
    }

    public static boolean shouldIgnoreType(EClassifier classifier) {
        EAnnotation annotation = classifier.getEAnnotation("JsonType");
        return annotation != null && "false".equalsIgnoreCase((String)annotation.getDetails().get((Object)"include"));
    }

    public static String getIdentityProperty(EClassifier classifier) {
        return JsonAnnotations.getValue((ENamedElement)classifier, "JsonIdentity", "property");
    }

    protected static String getValue(ENamedElement element, String annotation, String property) {
        EAnnotation ann = element.getEAnnotation(annotation);
        if (ann != null && ann.getDetails().containsKey((Object)property)) {
            return (String)ann.getDetails().get((Object)property);
        }
        return null;
    }

    protected static List<String> getValues(ENamedElement element, String annotation, String property) {
        String value = JsonAnnotations.getValue(element, annotation, property);
        if (value == null) {
            return Collections.emptyList();
        }
        if (value.contains(",")) {
            String[] split = value.split(",");
            ArrayList<String> values = new ArrayList<String>();
            for (String s : split) {
                String v = s.trim();
                if (v.isEmpty()) continue;
                values.add(v);
            }
            return values;
        }
        return Collections.singletonList(value);
    }
}

