/*
 * Decompiled with CFR 0.152.
 */
package org.emfjson.jackson.databind.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.emfjson.jackson.databind.EMFContext;
import org.emfjson.jackson.databind.deser.ReferenceEntry;

public class CollectionDeserializer
extends JsonDeserializer<Collection<Object>> {
    private final JsonDeserializer<? extends EObject> deserializer;
    private final JsonDeserializer<? extends ReferenceEntry> referenceDeserializer;

    public CollectionDeserializer(JsonDeserializer<? extends EObject> deserializer, JsonDeserializer<ReferenceEntry> referenceDeserializer) {
        this.deserializer = deserializer;
        this.referenceDeserializer = referenceDeserializer;
    }

    public Collection<Object> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ArrayList<Object> values = new ArrayList<Object>();
        while (p.nextToken() != JsonToken.END_ARRAY) {
            EObject result = (EObject)this.deserializer.deserialize(p, ctxt);
            if (result == null) continue;
            values.add(result);
        }
        return values;
    }

    public Collection<Object> deserialize(JsonParser p, DeserializationContext ctxt, Collection<Object> intoValue) throws IOException {
        EObject parent = EMFContext.getParent((DatabindContext)ctxt);
        EReference feature = EMFContext.getReference((DatabindContext)ctxt);
        while (p.nextToken() != JsonToken.END_ARRAY) {
            EMFContext.setParent((DatabindContext)ctxt, parent);
            EMFContext.setFeature((DatabindContext)ctxt, (EStructuralFeature)feature);
            if (feature != null && feature.isContainment()) {
                EObject result = (EObject)this.deserializer.deserialize(p, ctxt);
                if (result == null) continue;
                intoValue.add(result);
                continue;
            }
            ReferenceEntry entry = (ReferenceEntry)this.referenceDeserializer.deserialize(p, ctxt);
            if (entry == null) continue;
            intoValue.add(entry);
        }
        return intoValue;
    }
}

