/*
 * Decompiled with CFR 0.152.
 */
package org.emfjson.jackson.databind.deser;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.emfjson.jackson.databind.deser.CollectionDeserializer;
import org.emfjson.jackson.databind.deser.EDataTypeDeserializer;
import org.emfjson.jackson.databind.deser.EMapDeserializer;
import org.emfjson.jackson.databind.deser.EObjectDeserializer;
import org.emfjson.jackson.databind.deser.ReferenceEntry;
import org.emfjson.jackson.databind.deser.ResourceDeserializer;
import org.emfjson.jackson.databind.property.EObjectPropertyMap;
import org.emfjson.jackson.databind.type.EcoreType;
import org.emfjson.jackson.module.EMFModule;

public class EMFDeserializers
extends Deserializers.Base {
    private final ResourceDeserializer _resourceDeserializer;
    private final JsonDeserializer<EList<Map.Entry<?, ?>>> _mapDeserializer;
    private final JsonDeserializer<Object> _dataTypeDeserializer;
    private final JsonDeserializer<ReferenceEntry> _referenceDeserializer;
    private final EObjectPropertyMap.Builder builder;

    public EMFDeserializers(EMFModule module) {
        this.builder = new EObjectPropertyMap.Builder(module.getIdentityInfo(), module.getTypeInfo(), module.getReferenceInfo(), module.getFeatures());
        this._resourceDeserializer = new ResourceDeserializer(module.getUriHandler());
        this._referenceDeserializer = module.getReferenceDeserializer();
        this._mapDeserializer = new EMapDeserializer();
        this._dataTypeDeserializer = new EDataTypeDeserializer();
    }

    public JsonDeserializer<?> findMapLikeDeserializer(MapLikeType type, DeserializationConfig config, BeanDescription beanDesc, KeyDeserializer keyDeserializer, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        if (type.isTypeOrSubTypeOf(EMap.class)) {
            return this._mapDeserializer;
        }
        return super.findMapLikeDeserializer(type, config, beanDesc, keyDeserializer, elementTypeDeserializer, elementDeserializer);
    }

    public JsonDeserializer<?> findEnumDeserializer(Class<?> type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        if (Enumerator.class.isAssignableFrom(type)) {
            return this._dataTypeDeserializer;
        }
        return super.findEnumDeserializer(type, config, beanDesc);
    }

    public JsonDeserializer<?> findCollectionDeserializer(CollectionType type, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) throws JsonMappingException {
        if (type.getContentType().isTypeOrSubTypeOf(EObject.class)) {
            return new CollectionDeserializer(new EObjectDeserializer(this.builder, type.getContentType().getRawClass()), this._referenceDeserializer);
        }
        return super.findCollectionDeserializer(type, config, beanDesc, elementTypeDeserializer, elementDeserializer);
    }

    public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        if (type.isTypeOrSubTypeOf(Resource.class)) {
            return this._resourceDeserializer;
        }
        if (type.isReferenceType()) {
            return this._referenceDeserializer;
        }
        if (type.isTypeOrSubTypeOf(EcoreType.DataType.class)) {
            return this._dataTypeDeserializer;
        }
        if (type.isTypeOrSubTypeOf(EObject.class)) {
            return new EObjectDeserializer(this.builder, type.getRawClass());
        }
        return super.findBeanDeserializer(type, config, beanDesc);
    }
}

