/*
 * Decompiled with CFR 0.152.
 */
package org.emfjson.jackson.module;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.Serializers;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.emf.ecore.EObject;
import org.emfjson.jackson.annotations.EcoreIdentityInfo;
import org.emfjson.jackson.annotations.EcoreReferenceInfo;
import org.emfjson.jackson.annotations.EcoreTypeInfo;
import org.emfjson.jackson.databind.deser.EMFDeserializers;
import org.emfjson.jackson.databind.deser.EcoreReferenceDeserializer;
import org.emfjson.jackson.databind.deser.ReferenceEntry;
import org.emfjson.jackson.databind.ser.EMFSerializers;
import org.emfjson.jackson.databind.ser.EcoreReferenceSerializer;
import org.emfjson.jackson.handlers.BaseURIHandler;
import org.emfjson.jackson.handlers.URIHandler;

public class EMFModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;
    private EcoreReferenceInfo referenceInfo;
    private EcoreTypeInfo typeInfo;
    private EcoreIdentityInfo identityInfo;
    private JsonSerializer<EObject> referenceSerializer;
    private JsonDeserializer<ReferenceEntry> referenceDeserializer;
    protected static final int DEFAULT_FEATURES = Feature.collectDefaults();
    protected int _moduleFeatures = DEFAULT_FEATURES;
    private URIHandler handler;

    public void setTypeInfo(EcoreTypeInfo info) {
        this.typeInfo = info;
    }

    public void setIdentityInfo(EcoreIdentityInfo identityInfo) {
        this.identityInfo = identityInfo;
    }

    public void setReferenceInfo(EcoreReferenceInfo referenceInfo) {
        this.referenceInfo = referenceInfo;
    }

    public void setReferenceSerializer(JsonSerializer<EObject> serializer) {
        this.referenceSerializer = serializer;
    }

    public JsonSerializer<EObject> getReferenceSerializer() {
        return this.referenceSerializer;
    }

    public void setReferenceDeserializer(JsonDeserializer<ReferenceEntry> deserializer) {
        this.referenceDeserializer = deserializer;
    }

    public JsonDeserializer<ReferenceEntry> getReferenceDeserializer() {
        return this.referenceDeserializer;
    }

    public static ObjectMapper setupDefaultMapper() {
        return EMFModule.setupDefaultMapper(null);
    }

    public static ObjectMapper setupDefaultMapper(JsonFactory factory) {
        ObjectMapper mapper = new ObjectMapper(factory);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
        dateFormat.setTimeZone(TimeZone.getDefault());
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        mapper.setDateFormat((DateFormat)dateFormat);
        mapper.setTimeZone(TimeZone.getDefault());
        mapper.registerModule((Module)new EMFModule());
        return mapper;
    }

    public void setupModule(Module.SetupContext context) {
        if (this.handler == null) {
            this.handler = new BaseURIHandler();
        }
        if (this.typeInfo == null) {
            this.typeInfo = new EcoreTypeInfo();
        }
        if (this.identityInfo == null) {
            this.identityInfo = new EcoreIdentityInfo();
        }
        if (this.referenceInfo == null) {
            this.referenceInfo = new EcoreReferenceInfo(this.handler);
        }
        if (this.referenceSerializer == null) {
            this.referenceSerializer = new EcoreReferenceSerializer(this.referenceInfo, this.typeInfo);
        }
        if (this.referenceDeserializer == null) {
            this.referenceDeserializer = new EcoreReferenceDeserializer(this.referenceInfo, this.typeInfo);
        }
        EMFDeserializers deserializers = new EMFDeserializers(this);
        EMFSerializers serializers = new EMFSerializers(this);
        context.addDeserializers((Deserializers)deserializers);
        context.addSerializers((Serializers)serializers);
        super.setupModule(context);
    }

    public String getModuleName() {
        return "emfjson-module";
    }

    public Version version() {
        return new Version(1, 0, 0, "rc1", "org.emfjson", "emfjson-jackson");
    }

    private EMFModule enable(Feature f) {
        this._moduleFeatures |= f.getMask();
        return this;
    }

    private EMFModule disable(Feature f) {
        this._moduleFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(Feature f) {
        return (this._moduleFeatures & f.getMask()) != 0;
    }

    public int getFeatures() {
        return this._moduleFeatures;
    }

    public EMFModule configure(Feature feature, boolean state) {
        if (state) {
            this.enable(feature);
        } else {
            this.disable(feature);
        }
        return this;
    }

    public void setUriHandler(URIHandler handler) {
        this.handler = handler;
    }

    public URIHandler getUriHandler() {
        return this.handler;
    }

    public EcoreIdentityInfo getIdentityInfo() {
        return this.identityInfo;
    }

    public EcoreTypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public EcoreReferenceInfo getReferenceInfo() {
        return this.referenceInfo;
    }

    public static enum Feature {
        OPTION_USE_ID(false),
        OPTION_SERIALIZE_TYPE(true),
        OPTION_SERIALIZE_DEFAULT_VALUE(false),
        OPTION_SERIALIZE_CONTAINMENT_AS_HREF(false);

        final boolean _defaultState;
        final int _mask;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(Boolean defaultState) {
            this._defaultState = defaultState;
            this._mask = 1 << this.ordinal();
        }

        public boolean enabledIn(int flags) {
            return (flags & this._mask) != 0;
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return this._mask;
        }
    }
}

