/*
 * Decompiled with CFR 0.152.
 */
package org.impalaframework.osgi.test;

import org.impalaframework.osgi.test.BundleLocationConfiguration;
import org.impalaframework.osgi.test.ConfigurableFileFilter;
import org.impalaframework.osgi.test.FileFetcher;
import org.impalaframework.osgi.test.RepositoryArtifactLocator;
import org.springframework.core.io.Resource;
import org.springframework.osgi.test.provisioning.ArtifactLocator;

public abstract class BaseBundleLocationConfiguration
implements BundleLocationConfiguration {
    public ArtifactLocator getArtifactLocator() {
        String repositoryRootDirectory = this.getRepositoryRootDirectory();
        String[] artifactLocatorFolders = this.getArtifactLocatorFolders();
        return new RepositoryArtifactLocator(repositoryRootDirectory, artifactLocatorFolders);
    }

    public Resource[] getTestBundleLocations() {
        String testBundleIncludes = this.getTestBundleIncludes();
        String testBundleExcludes = this.getTestBundleExcludes();
        String[] testBundleFolders = this.getTestBundleFolders();
        ConfigurableFileFilter fileFilter = new ConfigurableFileFilter(testBundleIncludes, testBundleExcludes);
        FileFetcher fileFetcher = new FileFetcher(this.getRepositoryRootDirectory(), testBundleFolders);
        return fileFetcher.getResources(fileFilter).toArray(new Resource[0]);
    }

    public Resource[] getExtenderBundleLocations() {
        String extenderBundleIncludes = this.getExtenderBundleIncludes();
        String extenderBundleExcludes = this.getExtenderBundleExcludes();
        String[] extenderBundleFolders = this.getExtenderBundleFolders();
        ConfigurableFileFilter fileFilter = new ConfigurableFileFilter(extenderBundleIncludes, extenderBundleExcludes);
        FileFetcher fileFetcher = new FileFetcher(this.getRepositoryRootDirectory(), extenderBundleFolders);
        return fileFetcher.getResources(fileFilter).toArray(new Resource[0]);
    }

    protected abstract String[] getArtifactLocatorFolders();

    protected abstract String[] getTestBundleFolders();

    protected abstract String getTestBundleExcludes();

    protected abstract String getTestBundleIncludes();

    protected abstract String[] getExtenderBundleFolders();

    protected abstract String getExtenderBundleExcludes();

    protected abstract String getExtenderBundleIncludes();

    protected abstract String getRepositoryRootDirectory();
}

