/*
 * Decompiled with CFR 0.152.
 */
package org.impalaframework.osgi.test;

import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.osgi.test.provisioning.ArtifactLocator;
import org.springframework.util.Assert;

public class RepositoryArtifactLocator
implements ArtifactLocator {
    private String repositoryRootDirectory;
    private String[] repositoryFolders;

    public RepositoryArtifactLocator(String repositoryRootDirectory, String[] repositoryFolders) {
        Assert.notNull((Object)repositoryRootDirectory);
        Assert.notNull((Object)repositoryFolders);
        this.repositoryRootDirectory = repositoryRootDirectory;
        this.repositoryFolders = repositoryFolders;
    }

    public Resource locateArtifact(String group, String id, String version) {
        return this.locateArtifact(group, id, version, null);
    }

    public Resource locateArtifact(String group, String id, String version, String type) {
        for (String folder : this.repositoryFolders) {
            String directory = this.repositoryRootDirectory + "/" + folder + "/";
            Resource resource = this.findBundleResource(directory, id, version, type);
            if (!resource.exists()) continue;
            return resource;
        }
        return null;
    }

    private Resource findBundleResource(String directory, String id, String version, String type) {
        FileSystemResource resource = new FileSystemResource(directory + id + "-" + version + (type != null ? "-" + type : "") + ".jar");
        return resource;
    }
}

