package org.jacorb.idl;

/*
 *        JacORB - a free Java ORB
 *
 *   Copyright (C) 1997-2011 Gerald Brose / The JacORB Team.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/**
 * @author Gerald Brose
 * @version $Id: FixedArraySize.java,v 1.13 2011-05-10 15:40:36 nick.cross Exp $
 */

public class FixedArraySize
    extends IdlSymbol
{
    public PosIntConst pos_int_const;

    public FixedArraySize( int num )
    {
        super( num );
    }

    public void parse()
    {
        pos_int_const.parse();
    }

    public int value()
    {
        return pos_int_const.value();
    }

    public void setPackage( String s )
    {
        s = parser.pack_replace( s );
        if( pack_name.length() > 0 )
            pack_name = s + "." + pack_name;
        else
            pack_name = s;
        pos_int_const.setPackage( s );
    }
}










