/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.scriptengine.cache;

import java.util.HashMap;
import java.util.Map;
import org.jaggeryjs.scriptengine.cache.CachingContext;
import org.jaggeryjs.scriptengine.cache.PackageWrapper;

public class ContextWrapper {
    private Map<String, PackageWrapper> packages = new HashMap<String, PackageWrapper>();
    private String context = null;

    public ContextWrapper(String context) {
        this.context = context;
    }

    public int getPathCount() {
        return this.packages.size();
    }

    public Map<String, PackageWrapper> getPackages() {
        return this.packages;
    }

    public PackageWrapper getPackage(String path) {
        return this.packages.get(ContextWrapper.getPackage(this.context, path));
    }

    public void removePackage(String path) {
        this.packages.remove(ContextWrapper.getPackage(this.context, path));
    }

    public void removeCachingContext(String path, String cacheKey) {
        PackageWrapper packageWrapper = this.getPackage(path);
        if (packageWrapper == null) {
            return;
        }
        packageWrapper.removeCachingContext(cacheKey);
        if (packageWrapper.getCachingContextCount() == 0) {
            this.removePackage(path);
        }
    }

    public void addPackage(String path, PackageWrapper packageWrapper) {
        this.packages.put(ContextWrapper.getPackage(this.context, path), packageWrapper);
    }

    public void addCachingContext(String path, String cacheKey, CachingContext ctx) {
        PackageWrapper packageWrapper = this.getPackage(path);
        if (packageWrapper == null) {
            packageWrapper = new PackageWrapper();
            this.addPackage(path, packageWrapper);
        }
        packageWrapper.addCachingContext(cacheKey, ctx);
    }

    public static String getPackage(String context, String path) {
        path = ContextWrapper.normalizeForPackage(ContextWrapper.normalizePath(path));
        String pack = ContextWrapper.normalizeForPackage(ContextWrapper.normalizePath(context));
        if (!path.equals("")) {
            pack = pack + path;
        }
        return pack;
    }

    private static String normalizeForPackage(String path) {
        path = path.replaceAll("[-\\(\\)\\s]", "_").replace("/", ".").replaceAll("(.)([0-9])", "$1_$2");
        return path;
    }

    private static String normalizePath(String path) {
        if (path.equals("") || path.equals("/")) {
            return "";
        }
        return path.startsWith("/") ? path : "/" + path;
    }
}

