/*
 * Decompiled with CFR 0.152.
 */
package org.jaggeryjs.scriptengine.security;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaggeryjs.scriptengine.exceptions.ScriptException;
import org.jaggeryjs.scriptengine.security.RhinoSecurityDomain;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SecurityController;

public class RhinoSecurityController
extends SecurityController {
    private static final Log log = LogFactory.getLog(RhinoSecurityController.class);
    private static final boolean IS_SECURITY_ENABLED = System.getSecurityManager() != null;

    public static boolean isSecurityEnabled() {
        return IS_SECURITY_ENABLED;
    }

    public Class getStaticSecurityDomainClassInternal() {
        return RhinoSecurityDomain.class;
    }

    public GeneratedClassLoader createClassLoader(final ClassLoader parentLoader, Object protectionDomain) {
        final ProtectionDomain domain = (ProtectionDomain)protectionDomain;
        return AccessController.doPrivileged(new PrivilegedAction<GeneratedClassLoader>(){

            @Override
            public GeneratedClassLoader run() {
                return new Loader(parentLoader, domain);
            }
        });
    }

    public ProtectionDomain getDynamicSecurityDomain(Object staticDomain) {
        CodeSource codeSource;
        if (staticDomain == null) {
            return null;
        }
        RhinoSecurityDomain securityDomain = (RhinoSecurityDomain)staticDomain;
        Policy policy = AccessController.doPrivileged(new PrivilegedAction<Policy>(){

            @Override
            public Policy run() {
                return Policy.getPolicy();
            }
        });
        if (policy == null) {
            return null;
        }
        try {
            codeSource = securityDomain.getCodeSource();
        }
        catch (ScriptException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        if (codeSource == null) {
            return null;
        }
        PermissionCollection permissions = policy.getPermissions(codeSource);
        permissions.add(new RuntimePermission("getClassLoader"));
        try {
            this.updatePermissions(permissions, securityDomain);
        }
        catch (ScriptException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return new ProtectionDomain(codeSource, permissions);
    }

    protected void updatePermissions(PermissionCollection permissions, RhinoSecurityDomain securityDomain) throws ScriptException {
    }

    public Object callWithDomain(Object securityDomain, final Context cx, final Callable callable, final Scriptable scope, final Scriptable thisObj, final Object[] args) {
        ProtectionDomain staticDomain = (ProtectionDomain)securityDomain;
        ProtectionDomain dynamicDomain = this.getDynamicSecurityDomain(staticDomain);
        ProtectionDomain[] tmp = new ProtectionDomain[]{dynamicDomain};
        AccessControlContext restricted = new AccessControlContext(tmp);
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                return callable.call(cx, scope, thisObj, args);
            }
        };
        return AccessController.doPrivileged(action, restricted);
    }

    private static class Loader
    extends SecureClassLoader
    implements GeneratedClassLoader {
        private ProtectionDomain domain;

        Loader(ClassLoader parent, ProtectionDomain domain) {
            super(parent != null ? parent : Loader.getSystemClassLoader());
            this.domain = domain;
        }

        public Class defineClass(String name, byte[] data) {
            return super.defineClass(name, data, 0, data.length, this.domain);
        }

        public void linkClass(Class cl) {
            this.resolveClass(cl);
        }
    }
}

