/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.deployment;

import java.io.File;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jboss.as.plugin.common.DeploymentFailureException;
import org.jboss.as.plugin.deployment.AbstractDeployment;
import org.jboss.as.plugin.deployment.Deployment;

@Mojo(name="deploy-artifact", requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public final class DeployArtifact
extends AbstractDeployment {
    @Parameter
    private String groupId;
    @Parameter
    private String artifactId;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="true", property="deploy.force")
    private boolean force;
    private File file;

    @Override
    public void validate() throws DeploymentFailureException {
        super.validate();
        if (this.artifactId == null) {
            throw new DeploymentFailureException("deploy-artifact must specify the artifactId");
        }
        if (this.groupId == null) {
            throw new DeploymentFailureException("deploy-artifact must specify the groupId");
        }
        Set dependencies = this.project.getArtifacts();
        dependencies.addAll(this.project.getDependencyArtifacts());
        Artifact artifact = null;
        for (Artifact a : dependencies) {
            if (!a.getArtifactId().equals(this.artifactId) || !a.getGroupId().equals(this.groupId)) continue;
            artifact = a;
            break;
        }
        if (artifact == null) {
            throw new DeploymentFailureException("Could not resolve artifact to deploy " + this.groupId + ":" + this.artifactId);
        }
        this.file = artifact.getFile();
    }

    @Override
    protected File file() {
        return this.file;
    }

    @Override
    public String goal() {
        return "deploy-artifact";
    }

    @Override
    public Deployment.Type getType() {
        return this.force ? Deployment.Type.FORCE_DEPLOY : Deployment.Type.DEPLOY;
    }

    @Override
    protected boolean checkPackaging() {
        return false;
    }
}

