/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.plugin.common.ServerOperations;
import org.jboss.dmr.ModelNode;

public class DeploymentInspector {
    private DeploymentInspector() {
    }

    public static List<String> getDeployments(ModelControllerClient client, String exactComparisonName, String matchPattern) {
        ArrayList<String> result;
        block6: {
            if (exactComparisonName == null && matchPattern == null) {
                throw new IllegalArgumentException("exactComparisonName and matchPattern are null. One of them must be set in order to find an existing deployment.");
            }
            ModelNode op = ServerOperations.createListDeploymentsOperation();
            result = new ArrayList<String>();
            try {
                ModelNode listDeploymentsResult = client.execute(op);
                if (Operations.isSuccessfulOutcome((ModelNode)listDeploymentsResult)) {
                    if (ServerOperations.isSuccessfulOutcome((ModelNode)listDeploymentsResult)) {
                        List deployments = ServerOperations.readResult((ModelNode)listDeploymentsResult).asList();
                        for (ModelNode n : deployments) {
                            if (!DeploymentInspector.matches(n.asString(), exactComparisonName, matchPattern)) continue;
                            result.add(n.asString());
                        }
                    }
                    break block6;
                }
                throw new IllegalStateException(ServerOperations.getFailureDescriptionAsString(listDeploymentsResult));
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Could not execute operation '%s'", op), e);
            }
        }
        Collections.sort(result);
        return result;
    }

    private static boolean matches(String deploymentName, String exactComparisonName, String matchPattern) {
        if (matchPattern != null) {
            return deploymentName.matches(matchPattern);
        }
        return exactComparisonName.equals(deploymentName);
    }
}

