/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.server;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.jboss.as.plugin.server.AbstractArtifactResolver;
import org.jboss.as.plugin.server.ArtifactResolver;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.util.artifact.DefaultArtifact;

@Component(role=ArtifactResolver.class, hint="sonatype")
class SonatypeAetherArtifactResolver
extends AbstractArtifactResolver<DefaultArtifact>
implements ArtifactResolver {
    @Requirement
    private RepositorySystem repoSystem;

    SonatypeAetherArtifactResolver() {
    }

    @Override
    public File resolve(MavenProject project, String artifact) {
        ArtifactResult result;
        try {
            ProjectBuildingRequest projectBuildingRequest = SonatypeAetherArtifactResolver.invoke(project, "getProjectBuildingRequest", ProjectBuildingRequest.class);
            ArtifactRequest request = new ArtifactRequest();
            DefaultArtifact defaultArtifact = (DefaultArtifact)this.createArtifact(artifact);
            request.setArtifact((Artifact)defaultArtifact);
            List repos = SonatypeAetherArtifactResolver.invoke(project, "getRemoteProjectRepositories", List.class);
            request.setRepositories(repos);
            result = this.repoSystem.resolveArtifact(projectBuildingRequest.getRepositorySession(), request);
        }
        catch (ArtifactResolutionException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return result.getArtifact().getFile();
    }

    @Override
    protected DefaultArtifact constructArtifact(String groupId, String artifactId, String classifier, String packaging, String version) {
        return new DefaultArtifact(groupId, artifactId, classifier, packaging, version);
    }
}

