/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.structure.helpers;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.virtual.VirtualFile;

public class SecurityActions {
    static boolean isLeaf(VirtualFile f) throws IOException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return FileActions.PRIVILEGED.isLeaf(f);
        }
        return FileActions.NON_PRIVILEGED.isLeaf(f);
    }

    static interface FileActions {
        public static final FileActions PRIVILEGED = new FileActions(){

            public Boolean isLeaf(final VirtualFile f) throws IOException {
                try {
                    return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                        @Override
                        public Boolean run() throws Exception {
                            return f.isLeaf();
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    Exception ex = e.getException();
                    if (ex instanceof IOException) {
                        throw (IOException)ex;
                    }
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new UndeclaredThrowableException(ex);
                }
            }
        };
        public static final FileActions NON_PRIVILEGED = new FileActions(){

            public Boolean isLeaf(VirtualFile f) throws IOException {
                return f.isLeaf();
            }
        };

        public Boolean isLeaf(VirtualFile var1) throws IOException;
    }
}

