/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.structure.modified;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentContext;
import org.jboss.deployers.vfs.spi.structure.modified.AbstractStructureModificationChecker;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataStructureModificationChecker
extends AbstractStructureModificationChecker<Long> {
    private static final Set<String> CURRENT_PATH = Collections.singleton("");
    private VirtualFileFilter filter;

    public MetaDataStructureModificationChecker(MainDeployerStructure mainDeployer) {
        super(mainDeployer);
    }

    public void setFilter(VirtualFileFilter filter) {
        this.filter = filter;
    }

    @Override
    protected boolean hasRootBeenModified(VirtualFile root) throws IOException {
        String pathName = root.getPathName();
        Long cachedValue = (Long)this.getCache().getCacheValue(pathName);
        long lastModified = root.getLastModified();
        if (cachedValue != null) {
            return cachedValue < lastModified;
        }
        this.getCache().putCacheValue(pathName, lastModified);
        return false;
    }

    @Override
    protected boolean hasStructureBeenModifed(VirtualFile root, VFSDeploymentContext deploymentContext) throws IOException {
        StructureMetaData structureMetaData = (StructureMetaData)deploymentContext.getTransientManagedObjects().getAttachment(StructureMetaData.class);
        return this.hasStructureBeenModified(root, structureMetaData, null);
    }

    protected boolean hasStructureBeenModified(VirtualFile root, StructureMetaData structureMetaData, Set<String> excludedPaths) throws IOException {
        if (structureMetaData == null) {
            return false;
        }
        List contexts = structureMetaData.getContexts();
        if (contexts != null && !contexts.isEmpty()) {
            for (ContextInfo contextInfo : contexts) {
                String path;
                if (excludedPaths != null && excludedPaths.contains(path = contextInfo.getPath()) || !this.hasStructureBeenModifed(root, contextInfo)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasStructureBeenModifed(VirtualFile root, ContextInfo contextInfo) throws IOException {
        String path = contextInfo.getPath();
        VirtualFile contextRoot = root.getChild(path);
        if (contextRoot != null) {
            List metadataPaths = contextInfo.getMetaDataPath();
            if (metadataPaths != null && !metadataPaths.isEmpty()) {
                for (String metaDataPath : metadataPaths) {
                    VirtualFile mdpVF = contextRoot.getChild(metaDataPath);
                    if (mdpVF == null) continue;
                    List children = mdpVF.getChildren(this.filter);
                    String mdpPathName = mdpVF.getPathName();
                    Set<String> leaves = this.getCache().getLeaves(mdpPathName);
                    if (leaves != null && children != null && leaves.size() != children.size()) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("Metadata files number changed, old: " + leaves + ", now: " + children));
                        }
                        return true;
                    }
                    if (children != null && !children.isEmpty()) {
                        for (VirtualFile child : children) {
                            String pathName = child.getPathName();
                            if (leaves != null && !leaves.remove(pathName)) {
                                if (this.log.isTraceEnabled()) {
                                    this.log.trace((Object)("Found new metadata file: " + child));
                                }
                                return true;
                            }
                            Long timestamp = (Long)this.getCache().getCacheValue(pathName);
                            long lastModified = child.getLastModified();
                            if (timestamp != null) {
                                if (timestamp >= lastModified) continue;
                                if (this.log.isTraceEnabled()) {
                                    this.log.trace((Object)("Metadata location modified: " + child));
                                }
                                return true;
                            }
                            this.getCache().putCacheValue(pathName, lastModified);
                        }
                    } else {
                        this.getCache().putCacheValue(mdpPathName, System.currentTimeMillis());
                    }
                    if (leaves == null || leaves.isEmpty()) continue;
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("Missing old files: " + leaves));
                    }
                    return true;
                }
            }
            if (!"".equals(path)) {
                StructureMetaData structureMetaData = (StructureMetaData)contextInfo.getPredeterminedManagedObjects().getAttachment(StructureMetaData.class);
                return this.hasStructureBeenModified(contextRoot, structureMetaData, CURRENT_PATH);
            }
        }
        return false;
    }
}

