/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.structure.modified;

import java.io.IOException;
import org.jboss.deployers.structure.spi.main.MainDeployerStructure;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentContext;
import org.jboss.deployers.vfs.spi.structure.modified.AbstractStructureModificationChecker;
import org.jboss.deployers.vfs.spi.structure.modified.AddVisitor;
import org.jboss.deployers.vfs.spi.structure.modified.StructureCache;
import org.jboss.deployers.vfs.spi.structure.modified.SynchAdapter;
import org.jboss.deployers.vfs.spi.structure.modified.UpdateDeleteVisitor;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VirtualFileVisitor;
import org.jboss.virtual.VisitorAttributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchWrapperModificationChecker
extends AbstractStructureModificationChecker<Long> {
    private AbstractStructureModificationChecker<Long> delegate;
    private VirtualFileFilter filter;
    private SynchAdapter synchAdapter;
    private VisitorAttributes originalAttributes;
    private VisitorAttributes tempAttributes;

    public SynchWrapperModificationChecker(AbstractStructureModificationChecker<Long> delegate, SynchAdapter synchAdapter) {
        if (delegate == null) {
            throw new IllegalArgumentException("Null delegate");
        }
        if (synchAdapter == null) {
            throw new IllegalArgumentException("Null synch adapter");
        }
        this.delegate = delegate;
        this.synchAdapter = synchAdapter;
    }

    @Override
    protected StructureCache<Long> getCache() {
        return this.delegate.getCache();
    }

    @Override
    protected MainDeployerStructure getMainDeployerStructure() {
        return this.delegate.getMainDeployerStructure();
    }

    @Override
    protected boolean hasRootBeenModified(VirtualFile root) throws IOException {
        return this.delegate.hasRootBeenModified(root);
    }

    @Override
    protected boolean hasStructureBeenModifed(VirtualFile root, VFSDeploymentContext deploymentContext) throws IOException {
        boolean modified = this.delegate.hasStructureBeenModifed(root, deploymentContext);
        if (!modified && root != deploymentContext.getRoot()) {
            UpdateDeleteVisitor udVisitor = new UpdateDeleteVisitor(this.filter, this.tempAttributes, this.getCache(), this.synchAdapter, root);
            VirtualFile tempRoot = deploymentContext.getRoot();
            tempRoot.visit((VirtualFileVisitor)udVisitor);
            AddVisitor addVisitor = new AddVisitor(this.filter, this.originalAttributes, this.getCache(), this.synchAdapter, tempRoot, root.getPathName().length());
            root.visit((VirtualFileVisitor)addVisitor);
        }
        return modified;
    }

    @Override
    public void addStructureRoot(VirtualFile root) {
        this.delegate.addStructureRoot(root);
    }

    @Override
    public void removeStructureRoot(VirtualFile root) {
        this.delegate.removeStructureRoot(root);
    }

    public void setFilter(VirtualFileFilter filter) {
        this.filter = filter;
    }

    public void setOriginalAttributes(VisitorAttributes attributes) {
        this.originalAttributes = attributes;
    }

    public void setTempAttributes(VisitorAttributes attributes) {
        this.tempAttributes = attributes;
    }
}

