/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.migration;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.log4j.Logger;
import org.apache.xalan.trace.PrintTraceListener;
import org.apache.xalan.trace.TraceListener;
import org.apache.xalan.trace.TraceManager;
import org.apache.xalan.transformer.TransformerImpl;
import org.jbpm.migration.ErrorCollector;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public final class XmlUtils {
    static final Logger LOGGER = Logger.getLogger(XmlUtils.class);
    private static final DocumentBuilderFactory FACTORY = DocumentBuilderFactory.newInstance();

    private XmlUtils() {
    }

    public static Document createEmptyDocument() {
        Document output = null;
        try {
            DocumentBuilder db = FACTORY.newDocumentBuilder();
            db.setErrorHandler(new ParserErrorHandler());
            output = db.newDocument();
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Problem creating empty XML document.", (Throwable)ex);
        }
        return output;
    }

    public static Document parseFile(File input) {
        Document output = null;
        try {
            DocumentBuilder db = FACTORY.newDocumentBuilder();
            db.setErrorHandler(new ParserErrorHandler());
            output = db.parse(input);
        }
        catch (Exception ex) {
            String msg = "Problem parsing the input XML file";
            if (ex instanceof SAXParseException) {
                msg = msg + " at line #" + ((SAXParseException)ex).getLineNumber();
            }
            LOGGER.error((Object)msg, (Throwable)ex);
        }
        return output;
    }

    public static Document parseString(String input) {
        Document output = null;
        try {
            DocumentBuilder db = FACTORY.newDocumentBuilder();
            db.setErrorHandler(new ParserErrorHandler());
            output = db.parse(new ByteArrayInputStream(input.getBytes()));
        }
        catch (Exception ex) {
            String msg = "Problem parsing the input XML string";
            if (ex instanceof SAXParseException) {
                msg = msg + " at line #" + ((SAXParseException)ex).getLineNumber();
            }
            LOGGER.error((Object)msg, (Throwable)ex);
        }
        return output;
    }

    public static void writeFile(Document input, File output) {
        StreamResult result = new StreamResult(new StringWriter());
        XmlUtils.format(new DOMSource(input), result);
        try {
            new FileWriter(output).write(result.getWriter().toString());
        }
        catch (IOException ioEx) {
            LOGGER.error((Object)"Problem writing XML to file.", (Throwable)ioEx);
        }
    }

    public static boolean validate(Source input, Source[] schemas) {
        boolean isValid = true;
        try {
            Validator val = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemas).newValidator();
            ParserErrorHandler eh = new ParserErrorHandler();
            val.setErrorHandler(eh);
            val.validate(input);
            if (eh.didErrorOccur()) {
                isValid = false;
                eh.logErrors(LOGGER);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Problem validating the given process definition.", (Throwable)ex);
            isValid = false;
        }
        return isValid;
    }

    public static void transform(Source input, Source sheet, Result output) {
        try {
            DOMResult intermediate = new DOMResult(XmlUtils.createEmptyDocument());
            XmlUtils.createTransformer(sheet).transform(input, intermediate);
            XmlUtils.format(new DOMSource(intermediate.getNode()), output);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Problem transforming XML file.", (Throwable)ex);
        }
    }

    public static void format(Source input, Result output) {
        try {
            Transformer transformer = XmlUtils.createTransformer(null);
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(input, output);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Problem formatting DOM representation.", (Throwable)ex);
        }
    }

    private static Transformer createTransformer(Source xsltSource) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        if (xsltSource != null) {
            URIResolver resolver = new URIResolver(){

                @Override
                public Source resolve(String href, String base) throws TransformerException {
                    return new StreamSource(Thread.currentThread().getContextClassLoader().getResourceAsStream(href));
                }
            };
            transformerFactory.setURIResolver(resolver);
            transformer = transformerFactory.newTransformer(xsltSource);
            transformer.setURIResolver(resolver);
        } else {
            transformer = transformerFactory.newTransformer();
        }
        if (LOGGER.isDebugEnabled()) {
            XmlUtils.instrumentTransformer(transformer);
        }
        return transformer;
    }

    private static void instrumentTransformer(Transformer transformer) throws Exception {
        transformer.setErrorListener(new TransformerErrorListener());
        if (transformer instanceof TransformerHandler) {
            transformer = ((TransformerHandler)((Object)transformer)).getTransformer();
        }
        if (transformer instanceof TransformerImpl) {
            TraceManager tm = ((TransformerImpl)transformer).getTraceManager();
            PrintTraceListener ptl = new PrintTraceListener(new PrintWriter(System.out));
            ptl.m_traceElements = true;
            ptl.m_traceGeneration = true;
            ptl.m_traceSelection = true;
            ptl.m_traceTemplates = true;
            ptl.m_traceExtension = true;
            tm.addTraceListener((TraceListener)ptl);
        }
    }

    static {
        FACTORY.setNamespaceAware(true);
    }

    private static class TransformerErrorListener
    extends ErrorCollector<TransformerException>
    implements ErrorListener {
        private TransformerErrorListener() {
        }
    }

    private static class ParserErrorHandler
    extends ErrorCollector<SAXParseException>
    implements ErrorHandler {
        private ParserErrorHandler() {
        }
    }
}

