/*
 * Decompiled with CFR 0.152.
 */
package org.joinfaces.autoconfigure.rewrite;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.joinfaces.ClasspathScanUtil;
import org.joinfaces.rewrite.SpringBootAnnotationConfigProvider;
import org.ocpsoft.rewrite.annotation.spi.AnnotationHandler;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.util.ClassUtils;

public class RewriteAnnotationHandlerAotProcessor
implements BeanFactoryInitializationAotProcessor {
    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        if (ClassUtils.isPresent((String)"org.ocpsoft.rewrite.annotation.spi.AnnotationHandler", (ClassLoader)RewriteAnnotationHandlerAotProcessor.class.getClassLoader())) {
            return new RewriteAnnotationProcessorContribution();
        }
        return null;
    }

    static class RewriteAnnotationProcessorContribution
    implements BeanFactoryInitializationAotContribution {
        RewriteAnnotationProcessorContribution() {
        }

        public void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
            SpringBootAnnotationConfigProvider rewriteAnnotationConfigProvider = new SpringBootAnnotationConfigProvider();
            List annotationHandlers = rewriteAnnotationConfigProvider.getAnnotationHandlers();
            for (AnnotationHandler annotationHandler : annotationHandlers) {
                generationContext.getRuntimeHints().reflection().registerType(annotationHandler.getClass(), new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS});
            }
            Set annotationClasses = rewriteAnnotationConfigProvider.getAnnotationClasses(annotationHandlers);
            Set classes = rewriteAnnotationConfigProvider.scanClasses(annotationClasses);
            ClasspathScanUtil.writeClassSet((GenerationContext)generationContext, (String)SpringBootAnnotationConfigProvider.PREPARED_SCAN_RESULT_PATH, (Collection)classes);
        }
    }
}

