/*
 * Decompiled with CFR 0.152.
 */
package uk.co.darrenhurley.ant.tasks;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.mozilla.javascript.tools.shell.AccessFileList;
import org.mozilla.javascript.tools.shell.Main;
import uk.co.darrenhurley.ant.types.Arg;
import uk.co.darrenhurley.ant.types.Source;

public class JsDocToolkit
extends Task {
    private String jsDocHome;
    private String template;
    private String outputDir;
    private Vector<Source> sources = new Vector();
    private Vector<Arg> args = new Vector();
    private Vector<FileSet> fileSets = new Vector();
    private String encoding = "UTF-8";
    private String extensions = "js";
    private String config = "";
    private String log = "";
    private String inputDir = "";
    private int depth = -1;
    private boolean isUnderscoredFunctions = false;
    private boolean isUndocumentedFunctions = false;
    private boolean isPrivate = false;
    private boolean isVerbose = false;
    private boolean isSuppressSourceOut = false;

    public void execute() throws BuildException {
        System.setProperty("jsdoc.dir", this.jsDocHome);
        String[] stringArray = this.createCmdArray();
        Main.main((String[])stringArray);
        AccessFileList.clearFileList();
    }

    public void addSource(Source source) {
        if (!this.sources.contains(source)) {
            this.sources.add(source);
        }
    }

    public void addArg(Arg arg) {
        if (!this.args.contains(arg)) {
            this.args.add(arg);
        }
    }

    public void addFileSet(FileSet fileSet) {
        if (!this.fileSets.contains(fileSet)) {
            this.fileSets.add(fileSet);
        }
    }

    private String[] createCmdArray() throws BuildException {
        int n;
        Vector<String> vector = new Vector<String>();
        vector.add(this.jsDocHome + "app/run.js");
        if (this.config != "") {
            vector.add("-c=" + this.config);
            vector.add("-j=" + this.jsDocHome + "app/run.js");
            return vector.toArray(new String[0]);
        }
        if (this.jsDocHome == null || this.template == null || this.outputDir == null) {
            throw new BuildException("jsdochome, template and outputdir are all compulsory attributes");
        }
        vector.add("-t=" + this.jsDocHome + "templates/" + this.template);
        vector.add("-d=" + this.outputDir);
        vector.add("-e=" + this.encoding);
        vector.add("-x=" + this.extensions);
        if (this.isUndocumentedFunctions) {
            vector.add("-a");
        }
        if (this.isSuppressSourceOut) {
            vector.add("-s");
        }
        if (this.isUnderscoredFunctions) {
            vector.add("-A");
        }
        if (this.isPrivate) {
            vector.add("-p");
        }
        if (this.isVerbose) {
            vector.add("-v");
        }
        if (this.log != "") {
            vector.add("-o=" + this.log);
        }
        if (this.inputDir != "") {
            if (this.depth == -1) {
                vector.add("-r");
            } else {
                vector.add("-r=" + this.depth);
            }
            vector.add(this.inputDir);
        } else if (this.sources.size() != 0 || this.fileSets.size() != 0) {
            for (n = 0; n < this.sources.size(); ++n) {
                vector.add(this.sources.elementAt(n).getFile());
            }
            for (n = 0; n < this.fileSets.size(); ++n) {
                FileSet fileSet = this.fileSets.elementAt(n);
                DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
                File file = directoryScanner.getBasedir();
                String[] stringArray = directoryScanner.getIncludedFiles();
                for (int i = 0; i < stringArray.length; ++i) {
                    File file2 = new File(file, stringArray[i]);
                    vector.add(file2.getAbsolutePath());
                }
            }
        } else {
            throw new BuildException("You must specify a inputdir attribute or source/fileset child element(s)");
        }
        if (this.args.size() != 0) {
            for (n = 0; n < this.args.size(); ++n) {
                vector.add("-D=\"" + this.args.elementAt(n).getName() + ":" + this.args.elementAt(n).getValue() + "\"");
            }
        }
        vector.add("-j=" + this.jsDocHome + "app/run.js");
        return vector.toArray(new String[0]);
    }

    public void setJsdochome(String string) {
        this.jsDocHome = string;
    }

    public void setTemplate(String string) {
        this.template = string;
    }

    public void setOutputdir(String string) {
        this.outputDir = string;
    }

    public void setInputdir(String string) {
        this.inputDir = string;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setSuppresssourceout(Boolean bl) {
        this.isSuppressSourceOut = bl;
    }

    public void setDepth(Integer n) {
        this.depth = n;
    }

    public void setIncludeundocumented(Boolean bl) {
        this.isUndocumentedFunctions = bl;
    }

    public void setIncludeunderscored(Boolean bl) {
        this.isUnderscoredFunctions = bl;
    }

    public void setIncludeprivate(Boolean bl) {
        this.isPrivate = bl;
    }

    public void setVerbose(Boolean bl) {
        this.isVerbose = bl;
    }

    public void setExtensions(String string) {
        this.extensions = string;
    }

    public void setConfig(String string) {
        this.config = string;
    }

    public void setLog(String string) {
        this.log = string;
    }
}

