/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.mapreduce;

import java.io.Serializable;
import java.util.Collection;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.Mapper;
import org.keycloak.models.sessions.infinispan.entities.ClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;

public class ClientSessionsOfUserSessionMapper
implements Mapper<String, SessionEntity, String, Object>,
Serializable {
    private String realm;
    private Collection<String> userSessions;
    private EmitValue emit = EmitValue.ENTITY;

    public ClientSessionsOfUserSessionMapper(String realm, Collection<String> userSessions) {
        this.realm = realm;
        this.userSessions = userSessions;
    }

    public ClientSessionsOfUserSessionMapper emitKey() {
        this.emit = EmitValue.KEY;
        return this;
    }

    public void map(String key, SessionEntity e, Collector<String, Object> collector) {
        if (!this.realm.equals(e.getRealm())) {
            return;
        }
        if (!(e instanceof ClientSessionEntity)) {
            return;
        }
        ClientSessionEntity entity = (ClientSessionEntity)e;
        if (this.userSessions.contains(entity.getUserSession())) {
            switch (this.emit) {
                case KEY: {
                    collector.emit((Object)entity.getId(), (Object)entity.getId());
                    break;
                }
                case ENTITY: {
                    collector.emit((Object)entity.getId(), (Object)entity);
                }
            }
        }
    }

    private static enum EmitValue {
        KEY,
        ENTITY;

    }
}

