/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.cache.CachedUserModel;
import org.keycloak.models.cache.infinispan.UserCacheSession;
import org.keycloak.models.cache.infinispan.entities.CachedUser;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RoleUtils;

public class UserAdapter
implements CachedUserModel {
    private final Supplier<UserModel> modelSupplier;
    protected final CachedUser cached;
    protected final UserCacheSession userProviderCache;
    protected final KeycloakSession keycloakSession;
    protected final RealmModel realm;
    protected volatile UserModel updated;

    public UserAdapter(CachedUser cached, UserCacheSession userProvider, KeycloakSession keycloakSession, RealmModel realm) {
        this.cached = cached;
        this.userProviderCache = userProvider;
        this.keycloakSession = keycloakSession;
        this.realm = realm;
        this.modelSupplier = this::getUserModel;
    }

    public UserModel getDelegateForUpdate() {
        if (this.updated == null) {
            this.userProviderCache.registerUserInvalidation(this.realm, this.cached);
            this.updated = this.modelSupplier.get();
            if (this.updated == null) {
                throw new IllegalStateException("Not found in database");
            }
        }
        return this.updated;
    }

    public boolean isMarkedForEviction() {
        return this.updated != null;
    }

    public void invalidate() {
        try {
            this.getDelegateForUpdate();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public long getCacheTimestamp() {
        return this.cached.getCacheTimestamp();
    }

    public ConcurrentHashMap getCachedWith() {
        return this.cached.getCachedWith();
    }

    public String getId() {
        if (this.updated != null) {
            return this.updated.getId();
        }
        return this.cached.getId();
    }

    public String getUsername() {
        if (this.updated != null) {
            return this.updated.getUsername();
        }
        return this.cached.getUsername();
    }

    public void setUsername(String username) {
        this.getDelegateForUpdate();
        username = KeycloakModelUtils.toLowerCaseSafe((String)username);
        this.updated.setUsername(username);
    }

    public Long getCreatedTimestamp() {
        return this.cached.getCreatedTimestamp();
    }

    public void setCreatedTimestamp(Long timestamp) {
    }

    public boolean isEnabled() {
        if (this.updated != null) {
            return this.updated.isEnabled();
        }
        return this.cached.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.getDelegateForUpdate();
        this.updated.setEnabled(enabled);
    }

    public void setSingleAttribute(String name, String value) {
        this.getDelegateForUpdate();
        this.updated.setSingleAttribute(name, value);
    }

    public void setAttribute(String name, List<String> values) {
        this.getDelegateForUpdate();
        this.updated.setAttribute(name, values);
    }

    public void removeAttribute(String name) {
        this.getDelegateForUpdate();
        this.updated.removeAttribute(name);
    }

    public String getFirstAttribute(String name) {
        if (this.updated != null) {
            return this.updated.getFirstAttribute(name);
        }
        return (String)this.cached.getAttributes(this.modelSupplier).getFirst((Object)name);
    }

    public List<String> getAttribute(String name) {
        if (this.updated != null) {
            return this.updated.getAttribute(name);
        }
        List result = (List)this.cached.getAttributes(this.modelSupplier).get((Object)name);
        return result == null ? Collections.emptyList() : result;
    }

    public Map<String, List<String>> getAttributes() {
        if (this.updated != null) {
            return this.updated.getAttributes();
        }
        return this.cached.getAttributes(this.modelSupplier);
    }

    public Set<String> getRequiredActions() {
        if (this.updated != null) {
            return this.updated.getRequiredActions();
        }
        return this.cached.getRequiredActions(this.modelSupplier);
    }

    public void addRequiredAction(UserModel.RequiredAction action) {
        this.getDelegateForUpdate();
        this.updated.addRequiredAction(action);
    }

    public void removeRequiredAction(UserModel.RequiredAction action) {
        this.getDelegateForUpdate();
        this.updated.removeRequiredAction(action);
    }

    public void addRequiredAction(String action) {
        this.getDelegateForUpdate();
        this.updated.addRequiredAction(action);
    }

    public void removeRequiredAction(String action) {
        this.getDelegateForUpdate();
        this.updated.removeRequiredAction(action);
    }

    public String getFirstName() {
        if (this.updated != null) {
            return this.updated.getFirstName();
        }
        return this.cached.getFirstName();
    }

    public void setFirstName(String firstName) {
        this.getDelegateForUpdate();
        this.updated.setFirstName(firstName);
    }

    public String getLastName() {
        if (this.updated != null) {
            return this.updated.getLastName();
        }
        return this.cached.getLastName();
    }

    public void setLastName(String lastName) {
        this.getDelegateForUpdate();
        this.updated.setLastName(lastName);
    }

    public String getEmail() {
        if (this.updated != null) {
            return this.updated.getEmail();
        }
        return this.cached.getEmail();
    }

    public void setEmail(String email) {
        this.getDelegateForUpdate();
        email = KeycloakModelUtils.toLowerCaseSafe((String)email);
        this.updated.setEmail(email);
    }

    public boolean isEmailVerified() {
        if (this.updated != null) {
            return this.updated.isEmailVerified();
        }
        return this.cached.isEmailVerified();
    }

    public void setEmailVerified(boolean verified) {
        this.getDelegateForUpdate();
        this.updated.setEmailVerified(verified);
    }

    public String getFederationLink() {
        if (this.updated != null) {
            return this.updated.getFederationLink();
        }
        return this.cached.getFederationLink();
    }

    public void setFederationLink(String link) {
        this.getDelegateForUpdate();
        this.updated.setFederationLink(link);
    }

    public String getServiceAccountClientLink() {
        if (this.updated != null) {
            return this.updated.getServiceAccountClientLink();
        }
        return this.cached.getServiceAccountClientLink();
    }

    public void setServiceAccountClientLink(String clientInternalId) {
        this.getDelegateForUpdate();
        this.updated.setServiceAccountClientLink(clientInternalId);
    }

    public Set<RoleModel> getRealmRoleMappings() {
        if (this.updated != null) {
            return this.updated.getRealmRoleMappings();
        }
        Set<RoleModel> roleMappings = this.getRoleMappings();
        HashSet<RoleModel> realmMappings = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof RealmModel) || !((RealmModel)container).getId().equals(this.realm.getId())) continue;
            realmMappings.add(role);
        }
        return realmMappings;
    }

    public Set<RoleModel> getClientRoleMappings(ClientModel app) {
        if (this.updated != null) {
            return this.updated.getClientRoleMappings(app);
        }
        Set<RoleModel> roleMappings = this.getRoleMappings();
        HashSet<RoleModel> appMappings = new HashSet<RoleModel>();
        for (RoleModel role : roleMappings) {
            RoleContainerModel container = role.getContainer();
            if (!(container instanceof ClientModel) || !((ClientModel)container).getId().equals(app.getId())) continue;
            appMappings.add(role);
        }
        return appMappings;
    }

    public boolean hasRole(RoleModel role) {
        if (this.updated != null) {
            return this.updated.hasRole(role);
        }
        if (this.cached.getRoleMappings(this.modelSupplier).contains(role.getId())) {
            return true;
        }
        Set<RoleModel> mappings = this.getRoleMappings();
        for (RoleModel mapping : mappings) {
            if (!mapping.hasRole(role)) continue;
            return true;
        }
        return RoleUtils.hasRoleFromGroup(this.getGroups(), (RoleModel)role, (boolean)true);
    }

    public void grantRole(RoleModel role) {
        this.getDelegateForUpdate();
        this.updated.grantRole(role);
    }

    public Set<RoleModel> getRoleMappings() {
        if (this.updated != null) {
            return this.updated.getRoleMappings();
        }
        HashSet<RoleModel> roles = new HashSet<RoleModel>();
        for (String id : this.cached.getRoleMappings(this.modelSupplier)) {
            RoleModel roleById = this.keycloakSession.realms().getRoleById(id, this.realm);
            if (roleById == null) {
                this.getDelegateForUpdate();
                return this.updated.getRoleMappings();
            }
            roles.add(roleById);
        }
        return roles;
    }

    public void deleteRoleMapping(RoleModel role) {
        this.getDelegateForUpdate();
        this.updated.deleteRoleMapping(role);
    }

    public Set<GroupModel> getGroups() {
        if (this.updated != null) {
            return this.updated.getGroups();
        }
        LinkedHashSet<GroupModel> groups = new LinkedHashSet<GroupModel>();
        for (String id : this.cached.getGroups(this.modelSupplier)) {
            GroupModel groupModel = this.keycloakSession.realms().getGroupById(id, this.realm);
            if (groupModel == null) {
                this.getDelegateForUpdate();
                return this.updated.getGroups();
            }
            groups.add(groupModel);
        }
        return groups;
    }

    public void joinGroup(GroupModel group) {
        this.getDelegateForUpdate();
        this.updated.joinGroup(group);
    }

    public void leaveGroup(GroupModel group) {
        this.getDelegateForUpdate();
        this.updated.leaveGroup(group);
    }

    public boolean isMemberOf(GroupModel group) {
        if (this.updated != null) {
            return this.updated.isMemberOf(group);
        }
        if (this.cached.getGroups(this.modelSupplier).contains(group.getId())) {
            return true;
        }
        Set<GroupModel> roles = this.getGroups();
        return RoleUtils.isMember(roles, (GroupModel)group);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserModel)) {
            return false;
        }
        UserModel that = (UserModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    private UserModel getUserModel() {
        return this.userProviderCache.getDelegate().getUserById(this.cached.getId(), this.realm);
    }
}

