/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cluster.infinispan;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.cluster.infinispan.LockEntry;
import org.keycloak.models.sessions.infinispan.util.KeycloakMarshallUtil;

@SerializeWith(value=ExternalizerImpl.class)
public class LockEntryPredicate
implements Predicate<Map.Entry<String, Serializable>> {
    private final Set<String> removedNodesAddresses;

    public LockEntryPredicate(Set<String> removedNodesAddresses) {
        this.removedNodesAddresses = removedNodesAddresses;
    }

    @Override
    public boolean test(Map.Entry<String, Serializable> entry) {
        if (!(entry.getValue() instanceof LockEntry)) {
            return false;
        }
        LockEntry lock = (LockEntry)entry.getValue();
        return this.removedNodesAddresses.contains(lock.getNode());
    }

    public static class ExternalizerImpl
    implements Externalizer<LockEntryPredicate> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, LockEntryPredicate obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallCollection((Collection)obj.removedNodesAddresses, (ObjectOutput)output);
        }

        public LockEntryPredicate readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public LockEntryPredicate readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            return new LockEntryPredicate((Set)KeycloakMarshallUtil.readCollection(input, KeycloakMarshallUtil.STRING_EXT, ConcurrentHashMap::newKeySet));
        }
    }
}

