/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import org.infinispan.Cache;
import org.keycloak.Config;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.ActionTokenStoreProvider;
import org.keycloak.models.ActionTokenStoreProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.sessions.infinispan.InfinispanActionTokenStoreProvider;
import org.keycloak.models.sessions.infinispan.entities.ActionTokenReducedKey;
import org.keycloak.models.sessions.infinispan.entities.ActionTokenValueEntity;

public class InfinispanActionTokenStoreProviderFactory
implements ActionTokenStoreProviderFactory {
    private volatile Cache<ActionTokenReducedKey, ActionTokenValueEntity> actionTokenCache;
    public static final String ACTION_TOKEN_EVENTS = "ACTION_TOKEN_EVENTS";
    private Config.Scope config;

    public ActionTokenStoreProvider create(KeycloakSession session) {
        return new InfinispanActionTokenStoreProvider(session, this.actionTokenCache);
    }

    public void init(Config.Scope config) {
        this.config = config;
    }

    private static Cache<ActionTokenReducedKey, ActionTokenValueEntity> initActionTokenCache(KeycloakSession session) {
        InfinispanConnectionProvider connections = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        Cache cache = connections.getCache("actionTokens");
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInit(KeycloakSessionFactory factory) {
        Cache<ActionTokenReducedKey, ActionTokenValueEntity> cache = this.actionTokenCache;
        if (cache == null) {
            InfinispanActionTokenStoreProviderFactory infinispanActionTokenStoreProviderFactory = this;
            synchronized (infinispanActionTokenStoreProviderFactory) {
                cache = this.actionTokenCache;
                if (cache == null) {
                    this.actionTokenCache = InfinispanActionTokenStoreProviderFactory.initActionTokenCache(factory.create());
                }
            }
        }
    }

    public void close() {
    }

    public String getId() {
        return "infinispan";
    }
}

