/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes.sessions;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.sessions.infinispan.changes.sessions.AbstractLastSessionRefreshStore;
import org.keycloak.models.sessions.infinispan.changes.sessions.SessionData;

public class PersisterLastSessionRefreshStore
extends AbstractLastSessionRefreshStore {
    protected static final Logger logger = Logger.getLogger(PersisterLastSessionRefreshStore.class);
    private final boolean offline;

    protected PersisterLastSessionRefreshStore(int maxIntervalBetweenMessagesSeconds, int maxCount, boolean offline) {
        super(maxIntervalBetweenMessagesSeconds, maxCount);
        this.offline = offline;
    }

    @Override
    protected void sendMessage(KeycloakSession kcSession, Map<String, SessionData> refreshesToSend) {
        Map sessionIdsByRealm = refreshesToSend.entrySet().stream().collect(Collectors.groupingBy(entry -> ((SessionData)entry.getValue()).getRealmId(), Collectors.mapping(Map.Entry::getKey, Collectors.toSet())));
        int lastSessionRefresh = Time.currentTime() - 60;
        if (logger.isDebugEnabled()) {
            logger.debugf("Updating %d userSessions with lastSessionRefresh: %d", refreshesToSend.size(), lastSessionRefresh);
        }
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)kcSession.getProvider(UserSessionPersisterProvider.class);
        for (Map.Entry entry2 : sessionIdsByRealm.entrySet()) {
            RealmModel realm = kcSession.realms().getRealm(entry2.getKey());
            if (realm == null) continue;
            Set userSessionIds = entry2.getValue();
            persister.updateLastSessionRefreshes(realm, lastSessionRefresh, userSessionIds, this.offline);
        }
    }
}

