/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.sessions.infinispan.RootAuthenticationSessionAdapter;
import org.keycloak.models.sessions.infinispan.entities.AuthenticationSessionEntity;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class AuthenticationSessionAdapter
implements AuthenticationSessionModel {
    private final KeycloakSession session;
    private final RootAuthenticationSessionAdapter parent;
    private final String tabId;
    private AuthenticationSessionEntity entity;

    public AuthenticationSessionAdapter(KeycloakSession session, RootAuthenticationSessionAdapter parent, String tabId, AuthenticationSessionEntity entity) {
        this.session = session;
        this.parent = parent;
        this.tabId = tabId;
        this.entity = entity;
    }

    private void update() {
        this.parent.update();
    }

    public String getTabId() {
        return this.tabId;
    }

    public RootAuthenticationSessionModel getParentSession() {
        return this.parent;
    }

    public RealmModel getRealm() {
        return this.parent.getRealm();
    }

    public ClientModel getClient() {
        return this.getRealm().getClientById(this.entity.getClientUUID());
    }

    public String getRedirectUri() {
        return this.entity.getRedirectUri();
    }

    public void setRedirectUri(String uri) {
        this.entity.setRedirectUri(uri);
        this.update();
    }

    public String getAction() {
        return this.entity.getAction();
    }

    public void setAction(String action) {
        this.entity.setAction(action);
        this.update();
    }

    public Set<String> getClientScopes() {
        if (this.entity.getClientScopes() == null || this.entity.getClientScopes().isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<String>(this.entity.getClientScopes());
    }

    public void setClientScopes(Set<String> clientScopes) {
        this.entity.setClientScopes(clientScopes);
        this.update();
    }

    public String getProtocol() {
        return this.entity.getProtocol();
    }

    public void setProtocol(String protocol) {
        this.entity.setProtocol(protocol);
        this.update();
    }

    public String getClientNote(String name) {
        return this.entity.getClientNotes() != null && name != null ? this.entity.getClientNotes().get(name) : null;
    }

    public void setClientNote(String name, String value) {
        if (this.entity.getClientNotes() == null) {
            this.entity.setClientNotes(new ConcurrentHashMap<String, String>());
        }
        if (name != null) {
            if (value == null) {
                this.entity.getClientNotes().remove(name);
            } else {
                this.entity.getClientNotes().put(name, value);
            }
        }
        this.update();
    }

    public void removeClientNote(String name) {
        if (this.entity.getClientNotes() != null && name != null) {
            this.entity.getClientNotes().remove(name);
        }
        this.update();
    }

    public Map<String, String> getClientNotes() {
        if (this.entity.getClientNotes() == null || this.entity.getClientNotes().isEmpty()) {
            return Collections.emptyMap();
        }
        ConcurrentHashMap<String, String> copy = new ConcurrentHashMap<String, String>();
        copy.putAll(this.entity.getClientNotes());
        return copy;
    }

    public void clearClientNotes() {
        this.entity.setClientNotes(new ConcurrentHashMap<String, String>());
        this.update();
    }

    public String getAuthNote(String name) {
        return this.entity.getAuthNotes() != null && name != null ? this.entity.getAuthNotes().get(name) : null;
    }

    public void setAuthNote(String name, String value) {
        if (this.entity.getAuthNotes() == null) {
            this.entity.setAuthNotes(new ConcurrentHashMap<String, String>());
        }
        if (name != null) {
            if (value == null) {
                this.entity.getAuthNotes().remove(name);
            } else {
                this.entity.getAuthNotes().put(name, value);
            }
        }
        this.update();
    }

    public void removeAuthNote(String name) {
        if (this.entity.getAuthNotes() != null && name != null) {
            this.entity.getAuthNotes().remove(name);
        }
        this.update();
    }

    public void clearAuthNotes() {
        this.entity.setAuthNotes(new ConcurrentHashMap<String, String>());
        this.update();
    }

    public void setUserSessionNote(String name, String value) {
        if (this.entity.getUserSessionNotes() == null) {
            this.entity.setUserSessionNotes(new ConcurrentHashMap<String, String>());
        }
        if (name != null) {
            if (value == null) {
                this.entity.getUserSessionNotes().remove(name);
            } else {
                this.entity.getUserSessionNotes().put(name, value);
            }
        }
        this.update();
    }

    public Map<String, String> getUserSessionNotes() {
        if (this.entity.getUserSessionNotes() == null) {
            return Collections.EMPTY_MAP;
        }
        ConcurrentHashMap<String, String> copy = new ConcurrentHashMap<String, String>();
        copy.putAll(this.entity.getUserSessionNotes());
        return copy;
    }

    public void clearUserSessionNotes() {
        this.entity.setUserSessionNotes(new ConcurrentHashMap<String, String>());
        this.update();
    }

    public Set<String> getRequiredActions() {
        HashSet<String> copy = new HashSet<String>();
        copy.addAll(this.entity.getRequiredActions());
        return copy;
    }

    public void addRequiredAction(String action) {
        this.entity.getRequiredActions().add(action);
        this.update();
    }

    public void removeRequiredAction(String action) {
        this.entity.getRequiredActions().remove(action);
        this.update();
    }

    public void addRequiredAction(UserModel.RequiredAction action) {
        this.addRequiredAction(action.name());
    }

    public void removeRequiredAction(UserModel.RequiredAction action) {
        this.removeRequiredAction(action.name());
    }

    public Map<String, CommonClientSessionModel.ExecutionStatus> getExecutionStatus() {
        return this.entity.getExecutionStatus();
    }

    public void setExecutionStatus(String authenticator, CommonClientSessionModel.ExecutionStatus status) {
        this.entity.getExecutionStatus().put(authenticator, status);
        this.update();
    }

    public void clearExecutionStatus() {
        this.entity.getExecutionStatus().clear();
        this.update();
    }

    public UserModel getAuthenticatedUser() {
        return this.entity.getAuthUserId() == null ? null : this.session.users().getUserById(this.getRealm(), this.entity.getAuthUserId());
    }

    public void setAuthenticatedUser(UserModel user) {
        if (user == null) {
            this.entity.setAuthUserId(null);
        } else {
            this.entity.setAuthUserId(user.getId());
        }
        this.update();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof AuthenticationSessionModel)) {
            return false;
        }
        AuthenticationSessionModel that = (AuthenticationSessionModel)o;
        return that.getTabId().equals(this.getTabId());
    }

    public int hashCode() {
        return this.getTabId().hashCode();
    }
}

