/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.sessions.infinispan.AuthenticationSessionAdapter;
import org.keycloak.models.sessions.infinispan.InfinispanAuthenticationSessionProvider;
import org.keycloak.models.sessions.infinispan.entities.AuthenticationSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.RootAuthenticationSessionEntity;
import org.keycloak.models.utils.RealmInfoUtil;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class RootAuthenticationSessionAdapter
implements RootAuthenticationSessionModel {
    private static final Logger log = Logger.getLogger(RootAuthenticationSessionAdapter.class);
    private KeycloakSession session;
    private InfinispanAuthenticationSessionProvider provider;
    private Cache<String, RootAuthenticationSessionEntity> cache;
    private RealmModel realm;
    private RootAuthenticationSessionEntity entity;
    private final int authSessionsLimit;
    private static Comparator<Map.Entry<String, AuthenticationSessionEntity>> TIMESTAMP_COMPARATOR = Comparator.comparingInt(e -> ((AuthenticationSessionEntity)e.getValue()).getTimestamp());

    public RootAuthenticationSessionAdapter(KeycloakSession session, InfinispanAuthenticationSessionProvider provider, Cache<String, RootAuthenticationSessionEntity> cache, RealmModel realm, RootAuthenticationSessionEntity entity, int authSessionsLimt) {
        this.session = session;
        this.provider = provider;
        this.cache = cache;
        this.realm = realm;
        this.entity = entity;
        this.authSessionsLimit = authSessionsLimt;
    }

    void update() {
        int expirationSeconds = RealmInfoUtil.getDettachedClientSessionLifespan((RealmModel)this.realm);
        this.provider.tx.replace(this.cache, this.entity.getId(), this.entity, expirationSeconds, TimeUnit.SECONDS);
    }

    public String getId() {
        return this.entity.getId();
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public int getTimestamp() {
        return this.entity.getTimestamp();
    }

    public void setTimestamp(int timestamp) {
        this.entity.setTimestamp(timestamp);
        this.update();
    }

    public Map<String, AuthenticationSessionModel> getAuthenticationSessions() {
        HashMap<String, AuthenticationSessionModel> result = new HashMap<String, AuthenticationSessionModel>();
        for (Map.Entry<String, AuthenticationSessionEntity> entry : this.entity.getAuthenticationSessions().entrySet()) {
            String tabId = entry.getKey();
            result.put(tabId, new AuthenticationSessionAdapter(this.session, this, tabId, entry.getValue()));
        }
        return result;
    }

    public AuthenticationSessionModel getAuthenticationSession(ClientModel client, String tabId) {
        if (client == null || tabId == null) {
            return null;
        }
        AuthenticationSessionModel authSession = this.getAuthenticationSessions().get(tabId);
        if (authSession != null && client.equals(authSession.getClient())) {
            this.session.getContext().setAuthenticationSession(authSession);
            return authSession;
        }
        return null;
    }

    public AuthenticationSessionModel createAuthenticationSession(ClientModel client) {
        String tabId;
        Objects.requireNonNull(client, "client");
        Map<String, AuthenticationSessionEntity> authenticationSessions = this.entity.getAuthenticationSessions();
        if (authenticationSessions.size() >= this.authSessionsLimit && (tabId = (String)authenticationSessions.entrySet().stream().min(TIMESTAMP_COMPARATOR).map(Map.Entry::getKey).orElse(null)) != null) {
            log.debugf("Reached limit (%s) of active authentication sessions per a root authentication session. Removing oldest authentication session with TabId %s.", this.authSessionsLimit, (Object)tabId);
            authenticationSessions.remove(tabId);
        }
        AuthenticationSessionEntity authSessionEntity = new AuthenticationSessionEntity();
        authSessionEntity.setClientUUID(client.getId());
        int timestamp = Time.currentTime();
        authSessionEntity.setTimestamp(timestamp);
        String tabId2 = this.provider.generateTabId();
        authenticationSessions.put(tabId2, authSessionEntity);
        this.entity.setTimestamp(timestamp);
        this.update();
        AuthenticationSessionAdapter authSession = new AuthenticationSessionAdapter(this.session, this, tabId2, authSessionEntity);
        this.session.getContext().setAuthenticationSession((AuthenticationSessionModel)authSession);
        return authSession;
    }

    public void removeAuthenticationSessionByTabId(String tabId) {
        if (this.entity.getAuthenticationSessions().remove(tabId) != null) {
            if (this.entity.getAuthenticationSessions().isEmpty()) {
                this.provider.tx.remove(this.cache, this.entity.getId());
            } else {
                this.entity.setTimestamp(Time.currentTime());
                this.update();
            }
        }
    }

    public void restartSession(RealmModel realm) {
        this.entity.getAuthenticationSessions().clear();
        this.entity.setTimestamp(Time.currentTime());
        this.update();
    }
}

