/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.entities;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.cache.infinispan.DefaultLazyLoader;
import org.keycloak.models.cache.infinispan.LazyLoader;
import org.keycloak.models.cache.infinispan.entities.AbstractExtendableRevisioned;
import org.keycloak.models.cache.infinispan.entities.InRealm;

public class CachedUser
extends AbstractExtendableRevisioned
implements InRealm {
    private final String realm;
    private final String username;
    private final Long createdTimestamp;
    private final String email;
    private final boolean emailVerified;
    private final boolean enabled;
    private final String federationLink;
    private final String serviceAccountClientLink;
    private final int notBefore;
    private final LazyLoader<UserModel, Set<String>> requiredActions;
    private final LazyLoader<UserModel, MultivaluedHashMap<String, String>> attributes;
    private final LazyLoader<UserModel, Set<String>> roleMappings;
    private final LazyLoader<UserModel, Set<String>> groups;

    public CachedUser(Long revision, RealmModel realm, UserModel user, int notBefore) {
        super(revision, user.getId());
        this.realm = realm.getId();
        this.username = user.getUsername();
        this.createdTimestamp = user.getCreatedTimestamp();
        this.email = user.getEmail();
        this.emailVerified = user.isEmailVerified();
        this.enabled = user.isEnabled();
        this.federationLink = user.getFederationLink();
        this.serviceAccountClientLink = user.getServiceAccountClientLink();
        this.notBefore = notBefore;
        this.requiredActions = new DefaultLazyLoader<UserModel, Set>(userModel -> userModel.getRequiredActionsStream().collect(Collectors.toSet()), Collections::emptySet);
        this.attributes = new DefaultLazyLoader<UserModel, MultivaluedHashMap>(userModel -> new MultivaluedHashMap(userModel.getAttributes()), MultivaluedHashMap::new);
        this.roleMappings = new DefaultLazyLoader<UserModel, Set>(userModel -> userModel.getRoleMappingsStream().map(RoleModel::getId).collect(Collectors.toSet()), Collections::emptySet);
        this.groups = new DefaultLazyLoader<UserModel, Set>(userModel -> userModel.getGroupsStream().map(GroupModel::getId).collect(Collectors.toCollection(LinkedHashSet::new)), LinkedHashSet::new);
    }

    @Override
    public String getRealm() {
        return this.realm;
    }

    public String getUsername() {
        return this.username;
    }

    public Long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean isEmailVerified() {
        return this.emailVerified;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public MultivaluedHashMap<String, String> getAttributes(Supplier<UserModel> userModel) {
        return this.attributes.get(userModel);
    }

    public Set<String> getRequiredActions(Supplier<UserModel> userModel) {
        return this.requiredActions.get(userModel);
    }

    public Set<String> getRoleMappings(Supplier<UserModel> userModel) {
        return this.roleMappings.get(userModel);
    }

    public String getFederationLink() {
        return this.federationLink;
    }

    public String getServiceAccountClientLink() {
        return this.serviceAccountClientLink;
    }

    public Set<String> getGroups(Supplier<UserModel> userModel) {
        return this.groups.get(userModel);
    }

    public int getNotBefore() {
        return this.notBefore;
    }
}

