/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.entities;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;

@SerializeWith(value=ExternalizerImpl.class)
public class LoginFailureKey {
    private final String realmId;
    private final String userId;

    public LoginFailureKey(String realmId, String userId) {
        this.realmId = realmId;
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoginFailureKey key = (LoginFailureKey)o;
        if (this.realmId != null ? !this.realmId.equals(key.realmId) : key.realmId != null) {
            return false;
        }
        return !(this.userId != null ? !this.userId.equals(key.userId) : key.userId != null);
    }

    public int hashCode() {
        int result = this.realmId != null ? this.realmId.hashCode() : 0;
        result = 31 * result + (this.userId != null ? this.userId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("LoginFailureKey [ realmId=%s. userId=%s ]", this.realmId, this.userId);
    }

    public static class ExternalizerImpl
    implements Externalizer<LoginFailureKey> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, LoginFailureKey value) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)value.realmId, (ObjectOutput)output);
            MarshallUtil.marshallString((String)value.userId, (ObjectOutput)output);
        }

        public LoginFailureKey readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public LoginFailureKey readObjectVersion1(ObjectInput input) throws IOException {
            return new LoginFailureKey(MarshallUtil.unmarshallString((ObjectInput)input), MarshallUtil.unmarshallString((ObjectInput)input));
        }
    }
}

