/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.authorization.infinispan;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.authorization.infinispan.InfinispanStoreFactoryProvider;
import org.keycloak.models.authorization.infinispan.entities.CachedResource;

public class CachedResourceStore
implements ResourceStore {
    private static final String RESOURCE_ID_CACHE_PREFIX = "rsc-id-";
    private final KeycloakSession session;
    private final InfinispanStoreFactoryProvider.CacheTransaction transaction;
    private StoreFactory storeFactory;
    private ResourceStore delegate;
    private final Cache<String, List> cache;

    public CachedResourceStore(KeycloakSession session, InfinispanStoreFactoryProvider.CacheTransaction transaction) {
        this.session = session;
        InfinispanConnectionProvider provider = (InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class);
        this.cache = provider.getCache("authorization");
        this.transaction = transaction;
    }

    public Resource create(String name, ResourceServer resourceServer, String owner) {
        Resource resource = this.getDelegate().create(name, this.getStoreFactory().getResourceServerStore().findById(resourceServer.getId()), owner);
        return this.createAdapter(new CachedResource(resource));
    }

    public void delete(String id) {
        this.cache.evict((Object)this.getCacheKeyForResource(id));
        this.getDelegate().delete(id);
    }

    public Resource findById(String id) {
        String cacheKeyForResource = this.getCacheKeyForResource(id);
        List cached = (List)this.cache.get((Object)cacheKeyForResource);
        if (cached == null) {
            Resource resource = this.getDelegate().findById(id);
            if (resource != null) {
                return this.createAdapter(this.updateResourceCache(resource));
            }
            return null;
        }
        return this.createAdapter((CachedResource)cached.get(0));
    }

    public List<Resource> findByOwner(String ownerId) {
        ArrayList<Resource> cache = new ArrayList<Resource>();
        for (Map.Entry entry : this.cache.entrySet()) {
            List value;
            Resource resource2;
            String cacheKey = (String)entry.getKey();
            if (!cacheKey.startsWith(RESOURCE_ID_CACHE_PREFIX) || !(resource2 = (Resource)(value = (List)entry.getValue()).get(0)).getOwner().equals(ownerId)) continue;
            cache.add(this.findById(resource2.getId()));
        }
        if (cache.isEmpty()) {
            this.getDelegate().findByOwner(ownerId).forEach(resource -> cache.add(this.findById(this.updateResourceCache((Resource)resource).getId())));
        }
        return cache;
    }

    public List<Resource> findByResourceServer(String resourceServerId) {
        return this.getDelegate().findByResourceServer(resourceServerId);
    }

    public List<Resource> findByScope(String ... id) {
        return this.getDelegate().findByScope(id);
    }

    public Resource findByName(String name, String resourceServerId) {
        for (Map.Entry entry : this.cache.entrySet()) {
            List value;
            CachedResource resource;
            String cacheKey = (String)entry.getKey();
            if (!cacheKey.startsWith(RESOURCE_ID_CACHE_PREFIX) || !(resource = (CachedResource)(value = (List)entry.getValue()).get(0)).getResourceServerId().equals(resourceServerId) || !resource.getName().equals(name)) continue;
            return this.findById(resource.getId());
        }
        Resource resource = this.getDelegate().findByName(name, resourceServerId);
        if (resource != null) {
            return this.findById(this.updateResourceCache(resource).getId());
        }
        return null;
    }

    public List<Resource> findByType(String type) {
        ArrayList<Resource> cache = new ArrayList<Resource>();
        for (Map.Entry entry : this.cache.entrySet()) {
            List value;
            Resource resource2;
            String cacheKey = (String)entry.getKey();
            if (!cacheKey.startsWith(RESOURCE_ID_CACHE_PREFIX) || !(resource2 = (Resource)(value = (List)entry.getValue()).get(0)).getType().equals(type)) continue;
            cache.add(this.findById(resource2.getId()));
        }
        if (cache.isEmpty()) {
            this.getDelegate().findByType(type).forEach(resource -> cache.add(this.findById(this.updateResourceCache((Resource)resource).getId())));
        }
        return cache;
    }

    private String getCacheKeyForResource(String id) {
        return RESOURCE_ID_CACHE_PREFIX + id;
    }

    private ResourceStore getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.getStoreFactory().getResourceStore();
        }
        return this.delegate;
    }

    private StoreFactory getStoreFactory() {
        if (this.storeFactory == null) {
            this.storeFactory = (StoreFactory)this.session.getProvider(StoreFactory.class);
        }
        return this.storeFactory;
    }

    private Resource createAdapter(final CachedResource cached) {
        return new Resource(){
            private List<Scope> scopes;
            private Resource updated;

            public String getId() {
                return cached.getId();
            }

            public String getName() {
                return cached.getName();
            }

            public void setName(String name) {
                this.getDelegateForUpdate().setName(name);
                cached.setName(name);
            }

            public String getUri() {
                return cached.getUri();
            }

            public void setUri(String uri) {
                this.getDelegateForUpdate().setUri(uri);
                cached.setUri(uri);
            }

            public String getType() {
                return cached.getType();
            }

            public void setType(String type) {
                this.getDelegateForUpdate().setType(type);
                cached.setType(type);
            }

            public List<Scope> getScopes() {
                ArrayList<Scope> scopes = new ArrayList<Scope>();
                for (String id : cached.getScopesIds()) {
                    Scope cached2 = CachedResourceStore.this.getStoreFactory().getScopeStore().findById(id);
                    if (cached2 == null) continue;
                    scopes.add(cached2);
                }
                return scopes;
            }

            public String getIconUri() {
                return cached.getIconUri();
            }

            public void setIconUri(String iconUri) {
                this.getDelegateForUpdate().setIconUri(iconUri);
                cached.setIconUri(iconUri);
            }

            public ResourceServer getResourceServer() {
                return CachedResourceStore.this.getStoreFactory().getResourceServerStore().findById(cached.getResourceServerId());
            }

            public String getOwner() {
                return cached.getOwner();
            }

            public void updateScopes(Set<Scope> scopes) {
                this.getDelegateForUpdate().updateScopes(scopes.stream().map(scope -> CachedResourceStore.this.getStoreFactory().getScopeStore().findById(scope.getId())).collect(Collectors.toSet()));
                cached.updateScopes(scopes);
            }

            private Resource getDelegateForUpdate() {
                if (this.updated == null) {
                    this.updated = CachedResourceStore.this.getDelegate().findById(this.getId());
                    if (this.updated == null) {
                        throw new IllegalStateException("Not found in database");
                    }
                    CachedResourceStore.this.transaction.whenComplete(() -> CachedResourceStore.this.cache.evict((Object)CachedResourceStore.this.getCacheKeyForResource(this.getId())));
                }
                return this.updated;
            }
        };
    }

    private CachedResource updateResourceCache(Resource resource) {
        CachedResource cached = new CachedResource(resource);
        ArrayList<CachedResource> cache = new ArrayList<CachedResource>();
        cache.add(cached);
        this.cache.put((Object)this.getCacheKeyForResource(resource.getId()), cache);
        return cached;
    }
}

